/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jayeson.lib.sports.dispatch.network.IpRange;

public class IpFilter {
    final Set<IpRange> ranges;

    public IpFilter(String ranges) {
        List<String> tokens = IpFilter.tokenize(ranges, ";");
        List ipRanges = tokens.stream().map(IpFilter::parseRange).collect(Collectors.toList());
        if (ipRanges.contains(null)) {
            throw new IllegalArgumentException("Unable to parse " + ranges);
        }
        this.ranges = new HashSet(ipRanges);
    }

    static IpRange parseRange(String range) {
        List<String> tokens = IpFilter.tokenize(range, "-");
        try {
            if (tokens.size() == 1) {
                return new IpRange(tokens.get(0));
            }
            if (tokens.size() == 2) {
                return new IpRange(tokens.get(0), tokens.get(1));
            }
            return null;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    static List<String> tokenize(String input, String regex) {
        List<String> tokens = Arrays.asList(input.split(regex));
        return tokens.stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public boolean includes(String ip) {
        long address;
        try {
            address = IpRange.parseIp(ip);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to parse " + ip);
        }
        return this.ranges.stream().map(range -> range.includes(address)).reduce(false, Boolean::logicalOr);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ranges == null ? 0 : this.ranges.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpFilter other = (IpFilter)obj;
        return !(this.ranges == null ? other.ranges != null : !this.ranges.equals(other.ranges));
    }
}

