/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.metainfo.StreamNameCode;
import jayeson.lib.delivery.core.server.ServerEndPoint;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.IParticipantStats;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.core.TTLOutgoing;
import jayeson.lib.sports.core.TTLType;
import jayeson.lib.sports.datastructure.DataMessageWrapper;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.datastructure.OutgoingImpl;
import jayeson.lib.sports.dispatch.AbstractComparableEPDispatcher;
import jayeson.lib.sports.dispatch.network.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDispatcher
extends AbstractComparableEPDispatcher {
    private static Logger log = LoggerFactory.getLogger(NetworkDispatcher.class);
    private StreamNameCode snCode;
    private IEndPoint ep;
    private String username;

    @Inject
    public NetworkDispatcher(ScheduledExecutorService es, SportsFeedMessageGroup grp, StreamNameCode snCode, @Assisted IEndPoint ep, @Assisted String streamName) {
        super(streamName, grp, es);
        this.ep = ep;
        this.snCode = snCode;
    }

    @Override
    public String id() {
        return String.format("%s:%d:%s", this.ep.getPeerIp(), this.ep.getPeerPort(), this.getStream());
    }

    public String ip() {
        return String.format("%s", this.ep.getIdentifier());
    }

    public String getUsername() {
        if (this.username == null) {
            this.username = String.format("%s.%s", (String)((ServerEndPoint)this.ep).getData("username"), this.ep.getIdentifier());
        }
        return this.username;
    }

    @Override
    protected void handleMessage(Outgoing out) {
        try {
            MessageWrapper mw = null;
            if (this.grp.isIndicatorMessage(out.msgType())) {
                mw = this.generateWrapperForIndicatorMsg(out);
            } else {
                DataMessageWrapper deltaOut = (DataMessageWrapper)out;
                mw = new MessageWrapper((Object)deltaOut, deltaOut.msgType());
            }
            mw.addMetaInformation((MetaInformationCode)this.snCode, this.getStream());
            this.ep.send(mw);
            this.printMessage(out);
        }
        catch (Exception e) {
            log.error("Can not send snapshot.", (Throwable)e);
        }
    }

    private MessageWrapper generateWrapperForIndicatorMsg(Outgoing out) {
        DataMessageWrapper dataMessageWrapper = (DataMessageWrapper)out;
        MessageWrapper mw = null;
        mw = this.grp.isSwitchFilterStatusMsg(out.msgType()) ? new MessageWrapper(((OutgoingImpl)dataMessageWrapper.getOutgoingMsg()).msg(), out.msgType()) : (out.msgType() == this.grp.TTL_RESTORE_START ? new MessageWrapper((Object)dataMessageWrapper, out.msgType()) : new MessageWrapper(new Object(), out.msgType()));
        return mw;
    }

    @Override
    public CompletableFuture<Boolean> isInitialized() {
        CompletableFuture<Boolean> ready = new CompletableFuture<Boolean>();
        ready.complete(true);
        return ready;
    }

    private void printMessage(Outgoing outGng) {
        if (!(outGng instanceof TTLOutgoing) && outGng instanceof DeltaOutgoing) {
            IndexedSnapshot ss = ((DeltaOutgoing)outGng).delta();
            if (outGng.msgType().id() == this.grp.DATA_RESET.id()) {
                String identifier = "RESET";
                this.printPartitionKeys(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.ADMIN_REFRESH.id()) {
                String identifier = "REFRESH";
                this.printPartitionKeys(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_INSERT_MATCH.id()) {
                String identifier = "INSERT_MATCH";
                this.printPartitionKeys(identifier, ss);
                this.printMatch(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_UPDATE_MATCH.id()) {
                String identifier = "UPDATE_MATCH";
                this.printPartitionKeys(identifier, ss);
                this.printMatch(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_DELETE_MATCH.id()) {
                String identifier = "DELETE_MATCH";
                this.printPartitionKeys(identifier, ss);
                this.printMatch(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_INSERT_EVENT.id()) {
                String identifier = "INSERT_EVENT";
                this.printPartitionKeys(identifier, ss);
                this.printEventState(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_UPDATE_EVENT.id()) {
                String identifier = "UPDATE_EVENT";
                this.printPartitionKeys(identifier, ss);
                this.printEventState(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_DELETE_EVENT.id()) {
                String identifier = "DELETE_EVENT";
                this.printPartitionKeys(identifier, ss);
                this.printEventState(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_INSERT_ODD.id()) {
                String identifier = "INSERT_ODD";
                this.printPartitionKeys(identifier, ss);
                this.printRecord(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_UPDATE_ODD.id()) {
                String identifier = "UPDATE_ODD";
                this.printPartitionKeys(identifier, ss);
                this.printRecord(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.DATA_DELETE_ODD.id()) {
                String identifier = "DELETE_ODD";
                this.printPartitionKeys(identifier, ss);
                this.printRecord(identifier, ss);
            } else if (outGng.msgType().id() == this.grp.SWITCH_FILTER_START.id()) {
                log.info("[SWITCH_FILTER_START]");
            } else if (outGng.msgType().id() == this.grp.SWITCH_FILTER_END.id()) {
                log.info("[SWITCH_FILTER_END]");
            } else if (outGng.msgType().id() == this.grp.SWITCH_FILTER_FAIL.id()) {
                log.info("[SWITCH_FILTER_FAIL]");
            } else if (outGng.msgType().id() == this.grp.FULLSNAPSHOT_START.id()) {
                log.info("[FULLSNAPSHOT_START]");
            } else if (outGng.msgType().id() == this.grp.FULLSNAPSHOT_END.id()) {
                log.info("[FULLSNAPSHOT_END]");
            }
        } else if (outGng instanceof TTLOutgoing) {
            String identifier = "TTL";
            TTLOutgoing ts = (TTLOutgoing)outGng;
            identifier = ts.getTtlType() == TTLType.REMOVE ? "TTL_REM" : "TTL_RES";
            log.info("[{}][PK]{}", (Object)identifier, ts.delta().getPartitions());
        }
    }

    private void printEventState(String identifier, IndexedSnapshot ss) {
        for (IBetMatch match : ss.matches()) {
            Collection events = match.events();
            for (IBetEvent event : events) {
                LogUtil.getLogger(this.getUsername()).info("[{}] {}_{} duration : {} Host Score: {} Guest Score: {} to {}", new Object[]{identifier, event.matchId(), event.id(), event.eventState().duration(), ((IParticipantStats)event.eventState().stats().get(0)).getScores(), ((IParticipantStats)event.eventState().stats().get(1)).getScores(), this.getUsername()});
            }
        }
    }

    private void printMatch(String identifier, IndexedSnapshot ss) {
        for (IBetMatch match : ss.matches()) {
            LogUtil.getLogger(this.getUsername()).info("[{}] {} to {}", new Object[]{identifier, match.id(), this.getUsername()});
        }
    }

    private void printRecord(String identifier, IndexedSnapshot ss) {
        for (IBetMatch match : ss.matches()) {
            Collection events = match.events();
            for (IBetEvent event : events) {
                for (IBetRecord rec : event.records()) {
                    LogUtil.getLogger(this.getUsername()).info("[{}] {}_{}_{}_{}_{} to {}", new Object[]{identifier, rec.matchId(), rec.eventId(), rec.id(), rec.source(), rec.oddType(), this.getUsername()});
                }
            }
        }
    }

    private void printPartitionKeys(String identifier, IndexedSnapshot ss) {
        LogUtil.getLogger(this.getUsername()).info("[{}][PK]{} to {}", new Object[]{identifier, ss.getPartitions().toString(), this.getUsername()});
    }

    public String toString() {
        return String.format("ND@%s:%s", this.hashCode(), this.getUsername());
    }
}

