/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.codec.ResetMessageClass;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.DeltaOutgoingImpl;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.transform.CacheTracker;
import jayeson.lib.sports.dispatch.transform.CacheTrackingLogic;
import jayeson.lib.sports.filter.FilterableIndexSnapshot;
import jayeson.lib.sports.filter.FilterableOutgoing;
import jayeson.lib.sports.mutable.BuilderProvider;
import jayeson.lib.sports.mutable.IBetEventBuilder;
import jayeson.lib.sports.mutable.IBetMatchBuilder;
import jayeson.lib.sports.mutable.IIndexedSnapshotBuilder;
import jayeson.model.filter.FilterableMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterProcessor {
    private static Logger log = LoggerFactory.getLogger(FilterProcessor.class);
    protected CacheTracker cacheTracker = new CacheTracker();
    private SportsFeedMessageGroup grp;
    private CacheTrackingLogic cacheTrackerProcessorLogic;

    public FilterProcessor(SportsFeedMessageGroup grp, CacheTrackingLogic ct) {
        this.grp = grp;
        this.cacheTrackerProcessorLogic = ct;
    }

    public void cacheAll(IndexedSnapshot snapshot) {
        this.cacheTracker.insertMatchToCache(snapshot);
        this.cacheTracker.insertEventToCache(snapshot);
    }

    public void reset() {
        this.cacheTracker.cleanUp();
    }

    public List<Outgoing> update(FilterableOutgoing outgoing) {
        IMessageClass<?> cls = outgoing.msgType();
        if (cls instanceof ResetMessageClass) {
            return this.handleReset(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_INSERT_MATCH)) {
            return this.handleInsertMatch(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_UPDATE_MATCH)) {
            return this.handleUpdateMatch(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_DELETE_MATCH)) {
            return this.handleDeleteMatch(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_INSERT_EVENT)) {
            return this.handleInsertEvent(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_UPDATE_EVENT)) {
            return this.handleUpdateEvent(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_DELETE_EVENT)) {
            return this.handleDeleteEvent(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_INSERT_ODD)) {
            return this.handleInsertOdd(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_UPDATE_ODD)) {
            return this.handleUpdateOdd(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.DATA_DELETE_ODD)) {
            return this.handleDeleteOdd(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.ADMIN_REFRESH)) {
            return this.handleRefresh(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.TTL_REMOVE)) {
            return Arrays.asList(outgoing);
        }
        if (cls.isSameFormat((IMessageClass)this.grp.TTL_RESTORE)) {
            return Arrays.asList(outgoing);
        }
        log.warn("Received unexpected message {}. Returning as it is", cls);
        return Arrays.asList(outgoing);
    }

    private List<Outgoing> handleReset(FilterableOutgoing outGoing) {
        PartitionKey key = outGoing.delta().getPartitions().iterator().next();
        this.cacheTracker.clearPartition(key);
        return Arrays.asList(outGoing);
    }

    private List<Outgoing> handleRefresh(FilterableOutgoing outGoing) {
        try {
            IIndexedSnapshotBuilder refreshBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
            outGoing.delta().getPartitions().forEach(key -> {
                if (this.cacheTracker.containsPartition((PartitionKey)key)) {
                    refreshBuilder.markPartitionAsUpdated((PartitionKey)key);
                }
            });
            IndexedSnapshot output = (IndexedSnapshot)refreshBuilder.build();
            if (output.getPartitions().isEmpty()) {
                return Arrays.asList(new Outgoing[0]);
            }
            DeltaOutgoingImpl refreshMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.ADMIN_REFRESH, outGoing.after(), outGoing.before(), output);
            return Arrays.asList(refreshMessage);
        }
        catch (Exception e) {
            log.debug("error while processing refresh message", (Object)(e.getMessage() + " | " + Arrays.asList(e.getStackTrace())));
            return Arrays.asList(new Outgoing[0]);
        }
    }

    private List<Outgoing> handleInsertMatch(FilterableOutgoing outGoing) {
        IIndexedSnapshotBuilder matchSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        IndexedSnapshot insertMatchSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        FilterableIndexSnapshot delta = (FilterableIndexSnapshot)outGoing.delta();
        boolean passed = false;
        for (IBetMatch match : delta.matches()) {
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id())) continue;
            passed = true;
            matchSsBuilder.insertChild(match);
        }
        if (passed) {
            this.markPartition(delta, matchSsBuilder);
            insertMatchSs = (IndexedSnapshot)matchSsBuilder.build();
            this.cacheTracker.insertMatchToCache(insertMatchSs);
            DeltaOutgoingImpl insertMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_INSERT_MATCH, outGoing.after(), outGoing.before(), insertMatchSs);
            messages.add(insertMatchMessage);
        }
        return messages;
    }

    private List<Outgoing> handleInsertEvent(FilterableOutgoing outGoing) {
        IIndexedSnapshotBuilder insertEventSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        IIndexedSnapshotBuilder insertMatchSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        FilterableIndexSnapshot delta = (FilterableIndexSnapshot)outGoing.delta();
        PartitionKey key = delta.getPartitions().iterator().next();
        boolean passed = false;
        for (Object match : delta.matches()) {
            IBetMatch fullMatch = outGoing.getOriginal().after().match(match.id());
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id())) continue;
            for (IBetEvent event : match.events()) {
                if (!this.cacheTrackerProcessorLogic.hasEventCache(this.cacheTracker, match.id(), event.id())) continue;
                matchBuilder.insertChild(event);
                passed = true;
            }
            matchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(matchBuilder, key);
            insertEventSsBuilder.insertChild(matchBuilder.build());
        }
        if (passed) {
            this.markPartition(delta, insertEventSsBuilder);
            IndexedSnapshot insertEventSs = (IndexedSnapshot)insertEventSsBuilder.build();
            for (IBetMatch match : insertEventSs.matches()) {
                if (this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id(), key)) continue;
                IBetMatchBuilder builder = BuilderProvider.getBuilder(match, false);
                builder = this.cacheTrackerProcessorLogic.setPartitionKey(builder, key);
                IBetMatch newMatch = (IBetMatch)builder.build();
                insertMatchSsBuilder.insertChild(newMatch);
            }
            IndexedSnapshot newMatches = (IndexedSnapshot)(insertMatchSsBuilder = this.cacheTrackerProcessorLogic.markPartitionKey(insertMatchSsBuilder, key)).build();
            if (newMatches.matches().size() > 0) {
                this.cacheTracker.insertMatchToCache(newMatches);
                DeltaOutgoingImpl insertMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_INSERT_MATCH, outGoing.after(), outGoing.before(), newMatches);
                messages.add(insertMatchMessage);
            }
            this.cacheTracker.insertEventToCache(insertEventSs);
            DeltaOutgoingImpl insertEventMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_INSERT_EVENT, outGoing.after(), outGoing.before(), insertEventSs);
            messages.add(insertEventMessage);
        }
        return messages;
    }

    private List<Outgoing> handleUpdateOdd(FilterableOutgoing outGoing) {
        return this.filterEmptyOdds((IMessageClass<?>)this.grp.DATA_UPDATE_ODD, outGoing);
    }

    private List<Outgoing> filterEmptyOdds(IMessageClass<?> msgType, FilterableOutgoing outGoing) {
        IndexedSnapshot filteredDelta = this.filterEmptyOdds(outGoing.delta());
        if (filteredDelta.matches().isEmpty()) {
            return Arrays.asList(new Outgoing[0]);
        }
        DeltaOutgoingImpl oddMessage = new DeltaOutgoingImpl(msgType, outGoing.after(), outGoing.before(), filteredDelta);
        return Arrays.asList(oddMessage);
    }

    private IndexedSnapshot filterEmptyOdds(IndexedSnapshot input) {
        IIndexedSnapshotBuilder snapshotBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        HashSet<PartitionKey> partitions = new HashSet<PartitionKey>();
        for (IBetMatch match : input.matches()) {
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(match, false);
            for (IBetEvent event : match.events()) {
                IBetEventBuilder eventBuilder = BuilderProvider.getBuilder(event, false);
                for (IBetRecord record : event.records()) {
                    eventBuilder.insertChild(record);
                    partitions.add(new PartitionKey(record.source(), record.oddType(), match.sportType()));
                }
                IBetEvent eventAfterFiltering = (IBetEvent)eventBuilder.build();
                if (eventAfterFiltering.records().isEmpty()) continue;
                matchBuilder.insertChild(eventAfterFiltering);
            }
            IBetMatch matchAfterFiltering = (IBetMatch)matchBuilder.build();
            if (matchAfterFiltering.events().isEmpty()) continue;
            snapshotBuilder.insertChild(matchAfterFiltering);
        }
        partitions.forEach(key -> snapshotBuilder.markPartitionAsUpdated((PartitionKey)key));
        return (IndexedSnapshot)snapshotBuilder.build();
    }

    private List<Outgoing> handleUpdateMatch(FilterableOutgoing outGoing) {
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        FilterableIndexSnapshot delta = (FilterableIndexSnapshot)outGoing.delta();
        IIndexedSnapshotBuilder updateMatchSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        IndexedSnapshot updateMatchSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        PartitionKey key = delta.getPartitions().iterator().next();
        for (IBetMatch match : delta.matches()) {
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id())) continue;
            IBetMatch fullMatch = outGoing.getOriginal().after().match(match.id());
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
            matchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(matchBuilder, key);
            updateMatchSsBuilder.insertChild(matchBuilder.build());
        }
        this.markPartition(delta, updateMatchSsBuilder);
        updateMatchSs = (IndexedSnapshot)updateMatchSsBuilder.build();
        DeltaOutgoingImpl updateMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_UPDATE_MATCH, updateMatchSs);
        messages.add(updateMatchMessage);
        return messages;
    }

    private List<Outgoing> handleUpdateEvent(FilterableOutgoing outGoing) {
        IBetMatchBuilder matchBuilder;
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        FilterableIndexSnapshot delta = (FilterableIndexSnapshot)outGoing.delta();
        IIndexedSnapshotBuilder updateEventSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        IIndexedSnapshotBuilder insertMatchSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        PartitionKey key = delta.getPartitions().iterator().next();
        for (Object match : delta.matches()) {
            IBetMatch fullMatch = outGoing.after().match(match.id());
            matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id())) continue;
            for (IBetEvent event : match.events()) {
                if (!this.cacheTrackerProcessorLogic.hasEventCache(this.cacheTracker, match.id(), event.id())) continue;
                matchBuilder.insertChild(event);
            }
            IBetMatch matchWithUpdatedEvents = (IBetMatch)matchBuilder.build();
            if (matchWithUpdatedEvents.events().size() <= 0) continue;
            updateEventSsBuilder.insertChild(matchWithUpdatedEvents);
        }
        this.markPartition(delta, updateEventSsBuilder);
        IndexedSnapshot updateEventSs = (IndexedSnapshot)updateEventSsBuilder.build();
        for (IBetMatch match : updateEventSs.matches()) {
            if (this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id(), key)) continue;
            matchBuilder = BuilderProvider.getBuilder(match, false);
            matchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(matchBuilder, key);
            IBetMatch newMatch = (IBetMatch)matchBuilder.build();
            insertMatchSsBuilder.insertChild(newMatch);
        }
        this.markPartition(delta, insertMatchSsBuilder);
        IndexedSnapshot newMatches = (IndexedSnapshot)insertMatchSsBuilder.build();
        if (newMatches.matches().size() > 0) {
            this.cacheTracker.insertMatchToCache(newMatches);
            DeltaOutgoingImpl insertMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_INSERT_MATCH, outGoing.after(), outGoing.before(), newMatches);
            messages.add(insertMatchMessage);
        }
        if (updateEventSs.matches().size() > 0) {
            DeltaOutgoingImpl updateEventMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_UPDATE_EVENT, outGoing.after(), outGoing.before(), updateEventSs);
            messages.add(updateEventMessage);
        }
        return messages;
    }

    private List<Outgoing> handleInsertOdd(FilterableOutgoing outGoing) {
        IBetMatch fullMatch;
        IIndexedSnapshotBuilder insertMatchSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        IIndexedSnapshotBuilder insertEventSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        IIndexedSnapshotBuilder deleteEventSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        IIndexedSnapshotBuilder deleteMatchSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        FilterableIndexSnapshot delta = (FilterableIndexSnapshot)outGoing.delta();
        PartitionKey key = delta.getPartitions().iterator().next();
        for (IBetMatch match : delta.matches()) {
            fullMatch = outGoing.getOriginal().after().match(match.id());
            IBetMatchBuilder insertMatchBuilder = BuilderProvider.getBuilder(fullMatch, false);
            IBetMatchBuilder insertEventBuilder = BuilderProvider.getBuilder(fullMatch, false);
            insertMatchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(insertMatchBuilder, key);
            insertEventBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(insertEventBuilder, key);
            boolean toInsertMatch = false;
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id(), key)) {
                for (IBetEvent event : match.events()) {
                    if (event.records().isEmpty()) continue;
                    IBetEventBuilder eventBuilder = BuilderProvider.getBuilder(fullMatch.event(event.id()), false);
                    fullMatch.event(event.id()).eventStates().forEach(es -> eventBuilder.addState((IBetEventState)es));
                    event.records().forEach(r -> {
                        eventBuilder.insertChild(r);
                        PartitionKey pKey = new PartitionKey(r.source(), r.oddType(), match.sportType());
                        this.cacheTrackerProcessorLogic.insertIntoMatchCache(r.matchId(), this.cacheTracker, pKey);
                    });
                    insertEventBuilder.insertChild(eventBuilder.build());
                    toInsertMatch = true;
                }
            } else {
                for (IBetEvent event : match.events()) {
                    if (this.cacheTrackerProcessorLogic.hasEventCache(this.cacheTracker, match.id(), event.id(), key) || event.records().isEmpty()) continue;
                    IBetEvent fullEvent = this.cacheTrackerProcessorLogic.getEventWithPartitionKey(fullMatch, event.id(), key);
                    insertEventBuilder.insertChild(fullEvent);
                }
            }
            if (toInsertMatch) {
                IBetMatch matchToInsert = (IBetMatch)insertMatchBuilder.build();
                insertMatchSsBuilder.insertChild(matchToInsert);
            }
            if (insertEventBuilder.size() > 0) {
                IBetMatch matchContainingEventsToInsert = (IBetMatch)insertEventBuilder.build();
                insertEventSsBuilder.insertChild(matchContainingEventsToInsert);
            }
            FilterableMatch filterableMatch = (FilterableMatch)match;
            IBetMatchBuilder deleteEventBuilder = BuilderProvider.getBuilder(fullMatch, false);
            for (IBetEvent event : filterableMatch.unEvents()) {
                if (!this.cacheTrackerProcessorLogic.hasEventCache(this.cacheTracker, match.id(), event.id(), key)) continue;
                IBetEvent fullEvent = this.cacheTrackerProcessorLogic.getEventWithPartitionKey(fullMatch, event.id(), key);
                deleteEventBuilder.insertChild(fullEvent);
                this.cacheTracker.deleteEventFromCache(match.id(), event.id(), key);
            }
            IBetMatch eventsToDelete = (IBetMatch)(deleteEventBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(deleteEventBuilder, key)).build();
            if (eventsToDelete.events().size() <= 0) continue;
            deleteEventSsBuilder.insertChild(eventsToDelete);
            if (!this.cacheTracker.isEventEmpty(match.id())) continue;
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
            matchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(matchBuilder, key);
            deleteMatchSsBuilder.insertChild(matchBuilder.build());
            this.cacheTracker.deleteMatchFromCache(match.id(), key);
        }
        for (IBetMatch match : delta.unMatches()) {
            fullMatch = outGoing.getOriginal().after().match(match.id());
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id())) continue;
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
            matchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(matchBuilder, key);
            deleteMatchSsBuilder.insertChild(matchBuilder.build());
            this.cacheTracker.deleteMatchFromCache(match.id(), key);
        }
        insertMatchSsBuilder = this.cacheTrackerProcessorLogic.markPartitionKey(insertMatchSsBuilder, key, delta.getPartitionMap().get(key));
        insertEventSsBuilder = this.cacheTrackerProcessorLogic.markPartitionKey(insertEventSsBuilder, key, delta.getPartitionMap().get(key));
        deleteMatchSsBuilder = this.cacheTrackerProcessorLogic.markPartitionKey(deleteMatchSsBuilder, key, delta.getPartitionMap().get(key));
        deleteEventSsBuilder = this.cacheTrackerProcessorLogic.markPartitionKey(deleteEventSsBuilder, key, delta.getPartitionMap().get(key));
        IndexedSnapshot insertMatchSs = (IndexedSnapshot)insertMatchSsBuilder.build();
        IndexedSnapshot insertEventSs = (IndexedSnapshot)insertEventSsBuilder.build();
        IndexedSnapshot deleteMatchSs = (IndexedSnapshot)deleteMatchSsBuilder.build();
        IndexedSnapshot deleteEventSs = (IndexedSnapshot)deleteEventSsBuilder.build();
        if (insertMatchSs.matches().size() > 0) {
            this.cacheTracker.insertMatchToCache(insertMatchSs);
            DeltaOutgoingImpl insertMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_INSERT_MATCH, outGoing.after(), outGoing.before(), insertMatchSs);
            messages.add(insertMatchMessage);
        }
        if (insertEventSs.matches().size() > 0) {
            this.cacheTracker.insertEventToCache(insertEventSs);
            DeltaOutgoingImpl insertEventMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_INSERT_EVENT, outGoing.after(), outGoing.before(), insertEventSs);
            messages.add(insertEventMessage);
        }
        List<Outgoing> insertOddMessages = this.filterEmptyOdds((IMessageClass<?>)this.grp.DATA_INSERT_ODD, outGoing);
        messages.addAll(insertOddMessages);
        if (deleteEventSs.matches().size() > 0) {
            this.cacheTracker.deleteEventFromCache(deleteEventSs);
            DeltaOutgoingImpl deleteEventMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_DELETE_EVENT, outGoing.after(), outGoing.before(), deleteEventSs);
            messages.add(deleteEventMessage);
        }
        if (deleteMatchSs.matches().size() > 0) {
            this.cacheTrackerProcessorLogic.deleteFromMatchCache(deleteMatchSs, this.cacheTracker);
            DeltaOutgoingImpl deleteMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_DELETE_MATCH, outGoing.after(), outGoing.before(), deleteMatchSs);
            messages.add(deleteMatchMessage);
        }
        return messages;
    }

    private Map<PartitionKey, IBetMatchBuilder> generateDeleteEvents(IBetMatch match, PartitionKey key, boolean checkNoRecords) {
        HashMap<PartitionKey, IBetMatchBuilder> matches = new HashMap<PartitionKey, IBetMatchBuilder>();
        for (IBetEvent event : match.events()) {
            if (!this.cacheTrackerProcessorLogic.hasEventCache(this.cacheTracker, match.id(), event.id(), key)) continue;
            Collection<PartitionKey> keys = this.cacheTracker.getEventKeys(match.id(), event.id());
            keys.forEach(eventPartitionKey -> {
                IBetMatchBuilder matchBuilder = matches.computeIfAbsent((PartitionKey)eventPartitionKey, dummy -> BuilderProvider.getBuilder(match, false));
                if (!checkNoRecords) {
                    IBetEvent currEvent = this.cacheTrackerProcessorLogic.getEventWithPartitionKey(match, event.id(), (PartitionKey)eventPartitionKey);
                    matchBuilder.insertChild(currEvent);
                } else if (event.records().isEmpty()) {
                    matchBuilder.insertChild(event);
                }
            });
        }
        return matches;
    }

    private List<Outgoing> handleDeleteMatch(FilterableOutgoing outGoing) {
        IIndexedSnapshotBuilder deleteMatchSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        FilterableIndexSnapshot delta = (FilterableIndexSnapshot)outGoing.delta();
        PartitionKey key = delta.getPartitions().iterator().next();
        for (IBetMatch match : delta.matches()) {
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id(), key)) continue;
            IBetMatch fullMatch = outGoing.getOriginal().before().match(match.id());
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
            matchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(matchBuilder, key);
            deleteMatchSsBuilder.insertChild(matchBuilder.build());
        }
        IndexedSnapshot deletedMatches = (IndexedSnapshot)(deleteMatchSsBuilder = this.cacheTrackerProcessorLogic.markPartitionKey(deleteMatchSsBuilder, key)).build();
        if (deletedMatches.matches().size() > 0) {
            this.cacheTrackerProcessorLogic.deleteFromMatchCache(deletedMatches, this.cacheTracker);
            DeltaOutgoingImpl deleteMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_DELETE_MATCH, outGoing.after(), outGoing.before(), deletedMatches);
            messages.add(deleteMatchMessage);
        }
        return messages;
    }

    private List<Outgoing> handleDeleteEvent(FilterableOutgoing outGoing) {
        IIndexedSnapshotBuilder deleteEventSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        IIndexedSnapshotBuilder deleteMatchSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        FilterableIndexSnapshot delta = (FilterableIndexSnapshot)outGoing.delta();
        PartitionKey key = delta.getPartitions().iterator().next();
        for (IBetMatch deltaMatch : delta.matches()) {
            String matchId = deltaMatch.id();
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, matchId, key)) continue;
            IBetMatch fullMatch = outGoing.getOriginal().before().match(deltaMatch.id());
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
            for (IBetEvent deltaEvent : deltaMatch.events()) {
                String eventId = deltaEvent.id();
                if (!this.cacheTrackerProcessorLogic.hasEventCache(this.cacheTracker, matchId, eventId, key)) continue;
                IBetEvent eventToDelete = this.cacheTrackerProcessorLogic.getEventWithPartitionKey(fullMatch, eventId, key);
                matchBuilder.insertChild(eventToDelete);
            }
            IBetMatch matchWithDeletedEvents = (IBetMatch)(matchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(matchBuilder, key)).build();
            if (matchWithDeletedEvents.events().size() <= 0) continue;
            deleteEventSsBuilder.insertChild(matchWithDeletedEvents);
        }
        IndexedSnapshot deletedEvents = (IndexedSnapshot)(deleteEventSsBuilder = this.cacheTrackerProcessorLogic.markPartitionKey(deleteEventSsBuilder, key)).build();
        if (deletedEvents.matches().size() > 0) {
            this.cacheTracker.deleteEventFromCache(deletedEvents);
            DeltaOutgoingImpl deleteEventMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_DELETE_EVENT, outGoing.after(), outGoing.before(), deletedEvents);
            messages.add(deleteEventMessage);
            for (IBetMatch match : delta.matches()) {
                if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id(), key) || !this.cacheTracker.isEventEmpty(match.id())) continue;
                IBetMatch fullMatch = outGoing.getOriginal().before().match(match.id());
                IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
                matchBuilder = this.cacheTrackerProcessorLogic.setPartitionKey(matchBuilder, key);
                deleteMatchSsBuilder.insertChild(matchBuilder.build());
            }
            IndexedSnapshot deletedMatches = (IndexedSnapshot)deleteMatchSsBuilder.build();
            if (deletedMatches.matches().size() > 0) {
                this.cacheTrackerProcessorLogic.deleteFromMatchCache(deletedMatches, this.cacheTracker);
                DeltaOutgoingImpl deleteMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_DELETE_MATCH, outGoing.after(), outGoing.before(), deletedMatches);
                messages.add(deleteMatchMessage);
            }
        }
        return messages;
    }

    private List<Outgoing> handleDeleteOdd(FilterableOutgoing outGoing) {
        FilterableIndexSnapshot delta = (FilterableIndexSnapshot)outGoing.delta();
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        List<Outgoing> deleteOddMessages = this.filterEmptyOdds((IMessageClass<?>)this.grp.DATA_DELETE_ODD, outGoing);
        messages.addAll(deleteOddMessages);
        PartitionKey key = (PartitionKey)delta.getPartitions().stream().iterator().next();
        HashMap<PartitionKey, IIndexedSnapshotBuilder> deleteEventSS = new HashMap<PartitionKey, IIndexedSnapshotBuilder>();
        for (IBetMatch match : delta.matches()) {
            IBetMatch afterMatch = outGoing.after().match(match.id());
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id(), key)) continue;
            Map<PartitionKey, IBetMatchBuilder> matchWithDeletedEvents = null;
            if (afterMatch != null) {
                if (afterMatch.events().size() == 0) {
                    IBetMatch beforeMatch = outGoing.before().match(match.id());
                    matchWithDeletedEvents = this.generateDeleteEvents(beforeMatch, key, false);
                } else {
                    matchWithDeletedEvents = this.generateDeleteEvents(afterMatch, key, true);
                }
            } else {
                IBetMatch fullBeforeMatch = outGoing.before().match(match.id());
                matchWithDeletedEvents = this.generateDeleteEvents(fullBeforeMatch, key, false);
            }
            matchWithDeletedEvents.forEach((partKey, matchWithDeletedEvt) -> {
                IIndexedSnapshotBuilder ss = deleteEventSS.computeIfAbsent((PartitionKey)partKey, dummy -> BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT));
                ss.insertChild(matchWithDeletedEvt.build());
            });
        }
        deleteEventSS.forEach((eventPart, deleteEventSsBuilder) -> {
            deleteEventSsBuilder.markPartitionAsUpdated((PartitionKey)eventPart);
            IndexedSnapshot deletedEvents = (IndexedSnapshot)deleteEventSsBuilder.build();
            this.cacheTracker.deleteEventFromCache(deletedEvents);
            DeltaOutgoingImpl deleteEventMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_DELETE_EVENT, outGoing.after(), outGoing.before(), deletedEvents);
            messages.add(deleteEventMessage);
        });
        HashMap<PartitionKey, IIndexedSnapshotBuilder> deleteMatchSS = new HashMap<PartitionKey, IIndexedSnapshotBuilder>();
        for (IBetMatch match : delta.matches()) {
            IBetMatch fullMatch = outGoing.getOriginal().before().match(match.id());
            if (!this.cacheTrackerProcessorLogic.hasMatchCache(this.cacheTracker, match.id(), key) || !this.cacheTracker.isEventEmpty(match.id())) continue;
            Collection<PartitionKey> matchKeys = this.cacheTracker.getMatchKeys(match.id());
            matchKeys.forEach(matchKey -> {
                IIndexedSnapshotBuilder deleteMatchSsBuilder = deleteMatchSS.computeIfAbsent((PartitionKey)matchKey, dummy -> BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT));
                IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(fullMatch, false);
                deleteMatchSsBuilder.insertChild(matchBuilder.build());
            });
            this.cacheTrackerProcessorLogic.deleteFromMatchCache(match.id(), this.cacheTracker);
        }
        deleteMatchSS.forEach((matchKey, deleteMatchSsBuilder) -> {
            deleteMatchSsBuilder.markPartitionAsUpdated((PartitionKey)matchKey);
            IndexedSnapshot deletedMatches = (IndexedSnapshot)deleteMatchSsBuilder.build();
            DeltaOutgoingImpl deleteMatchMessage = new DeltaOutgoingImpl((IMessageClass<?>)this.grp.DATA_DELETE_MATCH, outGoing.after(), outGoing.before(), deletedMatches);
            messages.add(deleteMatchMessage);
        });
        return messages;
    }

    public void markPartition(FilterableIndexSnapshot delta, IIndexedSnapshotBuilder sSBuilder) {
        delta.getPartitionMap().entrySet().stream().forEach(e -> this.cacheTrackerProcessorLogic.markPartitionKey(sSBuilder, (PartitionKey)e.getKey(), (Long)e.getValue()));
    }
}

