/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.transform;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.core.TTLOutgoing;
import jayeson.lib.sports.core.TTLType;
import jayeson.lib.sports.datastructure.DeltaOutgoingImpl;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.AbstractEPG;
import jayeson.lib.sports.dispatch.FullSnapshotWrapper;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.OutFactory;
import jayeson.lib.sports.dispatch.PartialSnapshotWrapper;
import jayeson.lib.sports.dispatch.SwitchFilterSnapshotWrapper;
import jayeson.lib.sports.dispatch.TTLSnapshotWrapper;
import jayeson.lib.sports.dispatch.UpdateFilterSnapshotWrapper;
import jayeson.lib.sports.dispatch.transform.EndPointGroupCommandProcessor;
import jayeson.lib.sports.dispatch.transform.MessageEncoder;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterEventDispatcher;
import jayeson.model.IFilterEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringEPG
extends AbstractEPG {
    private static Logger log = LoggerFactory.getLogger(FilteringEPG.class);
    private IDataFilter filter;
    private final Map<String, EndPointGroupCommandProcessor> processors;
    private OutFactory.EPGFactory factory;
    private MessageEncoder msgEncoder;

    @Inject
    public FilteringEPG(MessageEncoder msgEncoder, ScheduledExecutorService executor, SportsFeedMessageGroup grp, OutFactory.EPGFactory factory) {
        super(executor, grp);
        this.msgEncoder = msgEncoder;
        this.processors = new ConcurrentHashMap<String, EndPointGroupCommandProcessor>();
        this.factory = factory;
    }

    @Override
    public void submitForProcess(IDispatchableWrapper wrap) {
        String queueName = this.generateQueueName(TEPG_Q_TYPE.PROCESS_WRAPPER.id());
        CompletableFuture<Void> f = this.submitToQueue(queueName, wrap, wrap.process());
        f.exceptionally(this::onException);
    }

    @Override
    public void submitForPostProcess(IDispatchableWrapper wrap) {
        String queueName = this.generateQueueName(TEPG_Q_TYPE.PROCESSS_SPECIAL_WRAPPER.id());
        CompletionStage<Void> f = this.submitToQueue(queueName, wrap, wrap.postProcess());
        f = f.exceptionally(this::onException);
    }

    public Void onException(Throwable e) {
        if (!(e instanceof CancellationException)) {
            log.error("Exception when dispatching snapshots to EPDs from FilteringEPG. ", e);
        }
        return null;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    private EndPointGroupCommandProcessor getProcessor(String stream) {
        return this.processors.get(stream);
    }

    @Override
    public void createEPGCP(String stream) {
        if (this.processors.get(stream) == null) {
            EndPointGroupCommandProcessor epgcp = this.factory.createEPGCP(this.msgEncoder, this, stream);
            this.processors.putIfAbsent(stream, epgcp);
        }
    }

    @Override
    public void setupFilter(IDataFilter newFilter, IFilterEventListener listener, ScheduledExecutorService ses) {
        this.filter = newFilter;
        if (this.filter.isRunnable()) {
            if (this.filter instanceof IFilterEventDispatcher) {
                listener.registerDispatcher((IFilterEventDispatcher)this.filter);
            }
            this.filter.registerAllEventsFromRules();
            this.filter.setExecutor(ses);
            this.filter.startAllRunnableRules();
        }
    }

    @Override
    public void teardownFilter() {
        if (this.filter == null) {
            return;
        }
        if (this.filter.isRunnable()) {
            this.filter.deregisterAllEventsFromRules();
            this.filter.stopAllRunnableRules();
            if (this.filter instanceof IFilterEventDispatcher) {
                IFilterEventDispatcher dispatcher = (IFilterEventDispatcher)this.filter;
                ArrayList registeredListeners = new ArrayList(dispatcher.registeredListeners());
                for (IFilterEventListener element : registeredListeners) {
                    element.deregisterDispatcher(dispatcher);
                }
            }
        }
    }

    @Override
    public Collection<Outgoing> generate(FullSnapshotWrapper wrapper) {
        String streamName = wrapper.getStream();
        EndPointGroupCommandProcessor processor = this.getProcessor(streamName);
        return processor.processFullSnapshot(wrapper);
    }

    @Override
    public Collection<Outgoing> generate(PartialSnapshotWrapper wrapper) {
        if (wrapper.getDelta() instanceof TTLOutgoing) {
            return this.generateTtl(wrapper);
        }
        String streamName = wrapper.getStream();
        EndPointGroupCommandProcessor processor = this.getProcessor(streamName);
        return processor.processPartialSnapshot(wrapper.getDelta());
    }

    @Override
    public Collection<Outgoing> generate(TTLSnapshotWrapper ttlWrapper, boolean fullSnapshot) {
        String streamName = ttlWrapper.getStream();
        EndPointGroupCommandProcessor processor = this.getProcessor(streamName);
        return processor.processTTLSnapshot(ttlWrapper, fullSnapshot);
    }

    @Override
    public Collection<Outgoing> generate(SwitchFilterSnapshotWrapper wrapper) {
        String streamName = wrapper.getStream();
        EndPointGroupCommandProcessor processor = this.getProcessor(streamName);
        return processor.processSwitchFilterSnapshot(wrapper);
    }

    @Override
    public Collection<Outgoing> generate(UpdateFilterSnapshotWrapper wrapper) {
        String streamName = wrapper.getStream();
        EndPointGroupCommandProcessor processor = this.getProcessor(streamName);
        return processor.processUpdateFilterSnapshot(wrapper);
    }

    private Collection<Outgoing> generateTtl(PartialSnapshotWrapper wrapper) {
        TTLOutgoing outGng = (TTLOutgoing)wrapper.getDelta();
        if (outGng.msgType().isSameFormat((IMessageClass)this.getSportsFeedGrp().ADMIN_REFRESH)) {
            return Arrays.asList(new Outgoing[0]);
        }
        TTLType ttlType = outGng.getTtlType();
        if (ttlType == TTLType.REMOVE) {
            EndPointGroupCommandProcessor processor = this.getProcessor(wrapper.getStream());
            return processor.processPartialSnapshot(wrapper.getDelta());
        }
        return this.generateTtlRestore(wrapper.getStream(), outGng);
    }

    private Collection<Outgoing> generateTtlRestore(String stream, TTLOutgoing outGng) {
        EndPointGroupCommandProcessor processor = this.getProcessor(stream);
        ArrayList<Outgoing> mwList = new ArrayList<Outgoing>();
        mwList.addAll(processor.processPartialSnapshot(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_MATCH, outGng.after(), outGng.before(), outGng.delta())));
        mwList.addAll(processor.processPartialSnapshot(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_EVENT, outGng.after(), outGng.before(), outGng.delta())));
        mwList.addAll(processor.processPartialSnapshot(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_ODD, outGng.after(), outGng.before(), outGng.delta())));
        return mwList;
    }

    @Override
    public void cleanUp() {
        String normalQueue = this.generateQueueName(TEPG_Q_TYPE.PROCESS_WRAPPER.id());
        String specialQueue = this.generateQueueName(TEPG_Q_TYPE.PROCESSS_SPECIAL_WRAPPER.id());
        this.workers.clear(normalQueue);
        this.workers.clear(specialQueue);
    }

    public String toString() {
        return "FilteringEPG@" + this.hashCode();
    }

    static enum TEPG_Q_TYPE {
        PROCESS_WRAPPER("tepg-wrapper-processing:%s"),
        PROCESSS_SPECIAL_WRAPPER("tepg-special-wrapper-processing:%s");

        private final String id;

        private TEPG_Q_TYPE(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }
    }
}

