/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.module;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import jayeson.lib.delivery.module.ModuleUtility;
import jayeson.lib.sports.client.MemoryDispatcher;
import jayeson.lib.sports.client.MemoryDispatcherFactory;
import jayeson.lib.sports.codec.PartitionCodec;
import jayeson.lib.sports.codec.SportCodecs;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.dispatch.EndPointGroupManager;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.IEndPointGroupManager;
import jayeson.lib.sports.dispatch.OutFactory;
import jayeson.lib.sports.dispatch.network.DistributedDispatcherfactory;
import jayeson.lib.sports.dispatch.network.NetworkDispatcher;
import jayeson.lib.sports.dispatch.relay.RelayEPG;
import jayeson.lib.sports.dispatch.transform.FilteringEPG;
import jayeson.lib.sports.receive.SportsFeedInProcessor;
import jayeson.lib.sports.receive.StreamCommandProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SportsFeedCoreComponentModule
extends AbstractModule {
    private static Logger log = LoggerFactory.getLogger(SportsFeedCoreComponentModule.class);

    protected void configure() {
        this.bind(SportsFeedMessageGroup.class);
        this.bind(SportCodecs.class).toInstance((Object)new SportCodecs());
        this.bind(PartitionCodec.class).toInstance((Object)new PartitionCodec());
        this.bind(SportsFeedInProcessor.class);
        this.bind(StreamCommandProcessor.class).in(Singleton.class);
        int cores = Runtime.getRuntime().availableProcessors() * 2;
        log.info("Setting executors with {} threads", (Object)cores);
        ThreadFactory executorThread = ModuleUtility.getNamedThreadFactory((String)"CommonExecutor-%d");
        ScheduledExecutorService commonExecutor = Executors.newScheduledThreadPool(cores, executorThread);
        this.bind(ScheduledExecutorService.class).toInstance((Object)commonExecutor);
        this.binder().install(new FactoryModuleBuilder().implement(IEndPointDispatcher.class, NetworkDispatcher.class).build(DistributedDispatcherfactory.class));
        this.binder().install(new FactoryModuleBuilder().implement(IEndPointDispatcher.class, MemoryDispatcher.class).build(MemoryDispatcherFactory.class));
        this.binder().install(new FactoryModuleBuilder().implement(IEndPointGroup.class, (Annotation)Names.named((String)"tepg"), FilteringEPG.class).implement(IEndPointGroup.class, (Annotation)Names.named((String)"repg"), RelayEPG.class).build(OutFactory.EPGFactory.class));
        this.binder().bind(IEndPointGroupManager.class).to(EndPointGroupManager.class);
    }
}

