/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import jayeson.database.soccer.SoccerFeedUserConfig;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.core.server.ServerEndPoint;
import jayeson.model.IDataFilter;
import jayeson.model.filter.GeneralDataFilter;
import org.slf4j.Logger;

public class FilterUtil {
    private static final ObjectMapper om = new ObjectMapper();

    public static IDataFilter mergeGeneralDataFilter(IEndPoint endPoint, IDataFilter filter, Logger log) {
        SoccerFeedUserConfig config;
        GeneralDataFilter mergedFilter = new GeneralDataFilter();
        try {
            config = (SoccerFeedUserConfig)((ServerEndPoint)endPoint).getData("config");
        }
        catch (Exception ex) {
            log.error("Error when get SoccerFeedUserConfig from endPoint {}", (Object)endPoint.getIdentifier());
            log.error("", (Throwable)ex);
            return filter;
        }
        IDataFilter filterInUser = FilterUtil.parseGeneralDataFilter(config.getFilters(), log);
        String filters = String.format("%s + %s", filterInUser, filter);
        if (filterInUser == null || filter == null) {
            mergedFilter = filter == null ? filterInUser : filter;
        } else {
            filterInUser.getFilterRules().forEach(arg_0 -> ((IDataFilter)mergedFilter).addFilterRule(arg_0));
            filter.getFilterRules().forEach(arg_0 -> ((IDataFilter)mergedFilter).addFilterRule(arg_0));
        }
        log.debug("[MergeFilter] {} = {}", (Object)filters, (Object)mergedFilter);
        return mergedFilter;
    }

    private static IDataFilter parseGeneralDataFilter(String filter, Logger log) {
        if (filter == null || filter.isEmpty() || "{}".equals(filter)) {
            return null;
        }
        try {
            return (IDataFilter)om.readValue(filter, GeneralDataFilter.class);
        }
        catch (Exception ex) {
            log.error("Error when parse GeneralDataFilter {}", (Object)filter);
            log.error("", (Throwable)ex);
            return null;
        }
    }
}

