/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.IParticipantStats;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.dispatch.EPGCache;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHelper {
    public static Logger feedInLog = LoggerFactory.getLogger((String)"FeedIn");
    public static Logger feedOutLog = LoggerFactory.getLogger((String)"FeedOut");
    public static Logger epgLog = LoggerFactory.getLogger((String)"EndPointGroup");
    private static final List<String> changeMessage = Lists.newArrayList((Object[])new String[]{"InsertMatch", "InsertEvent", "InsertOdd", "UpdateMatch", "UpdateEvent", "UpdateOdd", "DeleteMatch", "DeleteEvent", "DeleteOdd"});

    private static boolean isDataChangeMsg(String message) {
        return changeMessage.contains(message);
    }

    private static boolean isMatchChangeMsg(String message) {
        return LogHelper.isDataChangeMsg(message) && message.endsWith("Match");
    }

    private static boolean isEventChangeMsg(String message) {
        return LogHelper.isDataChangeMsg(message) && message.endsWith("Event");
    }

    private static List<List<Integer>> getScores(IBetEvent event) {
        return event.eventState() == null ? null : event.eventState().stats().stream().map(IParticipantStats::getScores).collect(Collectors.toList());
    }

    private static String getMsgType(IMessageClass messageClass) {
        Pattern pattern = Pattern.compile(".+\\.(?<class>[a-zA-Z]+)@(?<address>[a-zA-Z0-9]+)");
        Matcher matcherMsg = pattern.matcher(messageClass.toString());
        return matcherMsg.matches() ? matcherMsg.group("class").replace("MessageClass", "") : "";
    }

    private static String getPKeys(IndexedSnapshot snapshot) {
        return "[" + snapshot.getPartitionMap().keySet().stream().map(Objects::toString).collect(Collectors.joining(",")) + "]";
    }

    public static void logFeedUpdate(IndexedSnapshot snapshot, IMessageClass messageClass, String endPoint, InOut inOut) {
        Logger logger = InOut.IN == inOut ? feedInLog : feedOutLog;
        try {
            String msgType = LogHelper.getMsgType(messageClass);
            String pkey = LogHelper.getPKeys(snapshot);
            if (!LogHelper.isDataChangeMsg(msgType)) {
                logger.debug("{} {} {}", new Object[]{endPoint, msgType, pkey});
                return;
            }
            for (IBetMatch match : snapshot.matches()) {
                if (LogHelper.isMatchChangeMsg(msgType)) {
                    logger.debug("{} {} {} {}", new Object[]{endPoint, msgType, pkey, match.id()});
                    return;
                }
                for (IBetEvent event : match.events()) {
                    if (LogHelper.isEventChangeMsg(msgType)) {
                        logger.debug("{} {} {} {}_{}:{}", new Object[]{endPoint, msgType, pkey, match.id(), event.id(), LogHelper.getScores(event)});
                        return;
                    }
                    for (IBetRecord record : event.records()) {
                        logger.debug("{} {} {} {}_{}_{}:{}", new Object[]{endPoint, msgType, pkey, match.id(), event.id(), record.id(), record.rates()});
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public static void logChangeEPG(Action action, IEndPointGroup epg, EPGCache epgCache) {
        epgLog.debug("EPGCache {} {} EndPointGroup {} : filter {}", new Object[]{epgCache, action, epg, epg.getFilter()});
        epgLog.debug("EPGCache {} after {} EndPointGroup {} : {}", new Object[]{epgCache, action, epg, epgCache.getEPGs()});
    }

    public static void logCreateRelayEPG(IEndPointGroup relayEPG, EPGCache epgCache) {
        epgLog.debug("EPGCache {} ADD EndPointGroup {}", (Object)epgCache, (Object)relayEPG);
    }

    public static void logChangeEPD(Action action, IEndPointGroup epg, IEndPointDispatcher epd) {
        epgLog.debug("EndPointGroup {} {} EndPointDispatcher {} => {}", new Object[]{epg, action, epd, epg.getDispatcherNames()});
    }

    public static enum Action {
        ADD,
        REMOVE;

    }

    public static enum InOut {
        IN,
        OUT;

    }
}

