/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.datastructure;

import java.util.TreeMap;

public enum OddType {
    LIVE(0, "LIVE"),
    TODAY(1, "TODAY"),
    EARLY(2, "EARLY");

    private int _value;
    private String _display;
    private static final TreeMap<Integer, OddType> _map;

    private OddType(int value, String display) {
        this._value = value;
        this._display = display;
    }

    public int value() {
        return this._value;
    }

    public String dispText() {
        return this._display;
    }

    public String display() {
        return this._display;
    }

    public static int getNumOfValues() {
        return _map.size();
    }

    public static String getDispTextFromInt(int value) {
        return OddType.fromInt(value).dispText();
    }

    public static OddType fromInt(int value) {
        return _map.get(value);
    }

    static {
        _map = new TreeMap();
        for (OddType targetType : OddType.values()) {
            _map.put(new Integer(targetType.value()), targetType);
        }
    }
}

