/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.api;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.Attributable;
import jayeson.lib.feed.api.EventType;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.LBType;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.TimeType;

public interface IBetEvent
extends Attributable {
    public String id();

    public Collection<? extends IBetRecord> records();

    default public Collection<? extends IBetRecord> records(TimeType t) {
        return this.records().stream().filter(r -> r.timeType().equals(t)).collect(Collectors.toList());
    }

    public IBetEventState eventState();

    public Collection<? extends IBetEventState> eventStates();

    public String matchId();

    public EventType eventType();

    public IBetEventState getEventState(String var1);

    default public Collection<? extends IBetRecord> getRecords(String bookId) {
        return this.records().stream().filter(r -> r.source().equals(bookId)).collect(Collectors.toList());
    }

    default public Collection<? extends IBetRecord> getRecords(String bookId, TimeType timeType) {
        return this.records().stream().filter(r -> r.source().equals(bookId) && r.timeType().equals(timeType)).collect(Collectors.toList());
    }

    default public Collection<? extends IBetRecord> getRecords(String bookId, OddType oddType) {
        return this.records().stream().filter(r -> r.source().equals(bookId) && r.oddType().equals(oddType)).collect(Collectors.toList());
    }

    default public Collection<? extends IBetRecord> getRecords(String bookId, LBType lbType) {
        return this.records().stream().filter(r -> r.source().equals(bookId) && r.lbType().equals(lbType)).collect(Collectors.toList());
    }

    default public Collection<? extends IBetRecord> getRecords(List<String> bookIdList, LBType lbType) {
        return this.records().stream().filter(r -> bookIdList.contains(r.source()) && r.lbType().equals(lbType)).collect(Collectors.toList());
    }

    default public boolean hasSportbook(String bookId) {
        return this.records().stream().anyMatch(r -> r.source().equals(bookId));
    }

    default public boolean hasLBType(LBType lbType) {
        return this.records().stream().anyMatch(r -> r.lbType().equals(lbType));
    }

    default public boolean hasTimeType(TimeType timeType) {
        return this.records().stream().anyMatch(r -> r.timeType().equals(timeType));
    }

    default public boolean hasOddType(OddType oddType) {
        return this.records().stream().anyMatch(r -> r.oddType().equals(oddType));
    }

    default public boolean hasRecord(String source, long id) {
        for (IBetRecord iBetRecord : this.records()) {
            if (iBetRecord.id() != id || !iBetRecord.source().equals(source)) continue;
            return true;
        }
        return false;
    }

    default public IBetRecord record(String source, long id) {
        for (IBetRecord iBetRecord : this.records()) {
            if (iBetRecord.id() != id || !iBetRecord.source().equals(source)) continue;
            return iBetRecord;
        }
        return null;
    }
}

