/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.basketball;

import java.util.Arrays;
import java.util.List;
import jayeson.lib.feed.api.IParticipantStats;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.basketball.BasketballSegment;
import jayeson.lib.feed.basketball.BasketballStats;
import jayeson.lib.feed.core.B2EventState;

public class BasketballEventState
extends B2EventState {
    final BasketballSegment segment;
    final boolean isTimeout;
    final BasketballStats hostStat;
    final BasketballStats guestStat;

    public BasketballEventState(IParticipantStats statsOne, IParticipantStats statsTwo, int duration, PartitionKey key, String matchId, String eventId, BasketballSegment segment, boolean isTimeout, int bookPriority) {
        super(statsOne, statsTwo, duration, key, matchId, eventId, bookPriority);
        this.segment = segment;
        this.isTimeout = isTimeout;
        this.hostStat = (BasketballStats)statsOne;
        this.guestStat = (BasketballStats)statsTwo;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public int getMinutes() {
        return this.duration() / 60;
    }

    public int getSeconds() {
        return this.duration() % 60;
    }

    public int getHostQuarterScore(int quarterNum) {
        return this.hostStat.getQuarterScore(quarterNum);
    }

    public int getGuestQuarterScore(int quarterNum) {
        return this.guestStat.getQuarterScore(quarterNum);
    }

    public int getHostHalfScore(int segmentNum) {
        return this.hostStat.getHalfScore(segmentNum);
    }

    public int getGuestHalfScore(int segmentNum) {
        return this.guestStat.getHalfScore(segmentNum);
    }

    public int getHostTotalScore() {
        return this.hostStat.getTotalScore();
    }

    public int getGuestTotalScore() {
        return this.guestStat.getTotalScore();
    }

    @Override
    public BasketballSegment segment() {
        return this.segment;
    }

    @Override
    public List<IParticipantStats> stats() {
        return Arrays.asList(this.statsOne(), this.statsTwo());
    }

    @Override
    public IParticipantStats statsOf(int idx) {
        switch (idx) {
            case 0: {
                return this.statsOne();
            }
            case 1: {
                return this.statsTwo();
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

