/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.EventType;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetRecord;

public abstract class BetEvent
implements IBetEvent {
    private final String id;
    private final Collection<? extends IBetRecord> records;
    private final String matchId;
    private final EventType type;
    private final Map<String, String> meta;
    private final Collection<? extends IBetEventState> states;

    public BetEvent(String id, Collection<? extends IBetRecord> records, String matchId, EventType type, Collection<? extends IBetEventState> states, Map<String, String> meta) {
        this.id = id;
        this.records = records;
        this.matchId = matchId;
        this.type = type;
        this.states = states;
        this.meta = meta;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String matchId() {
        return this.matchId;
    }

    @Override
    public EventType eventType() {
        return this.type;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    @Override
    public Collection<? extends IBetRecord> records() {
        return this.records;
    }

    @Override
    public Map<String, String> meta() {
        return this.meta;
    }

    @Override
    public IBetEventState getEventState(String sportsBook) {
        Iterator<? extends IBetEventState> iterator = this.states.iterator();
        for (int i = 0; i < this.states.size(); ++i) {
            IBetEventState state = iterator.next();
            if (!sportsBook.matches(state.partitionKey().source())) continue;
            return state;
        }
        return null;
    }

    protected <T extends IBetEventState> IBetEventState getPrimaryEvent(Collection<T> states) {
        if (states == null || states.isEmpty()) {
            return null;
        }
        List eventStates = states.stream().sorted(new Comparator<IBetEventState>(){

            @Override
            public int compare(IBetEventState o1, IBetEventState o2) {
                return o1.bookPriority() - o2.bookPriority();
            }
        }).collect(Collectors.toList());
        return (IBetEventState)eventStates.get(0);
    }

    @Override
    public IBetEventState eventState() {
        return this.getPrimaryEvent(this.states);
    }

    @Override
    public Collection<? extends IBetEventState> eventStates() {
        return Collections.unmodifiableCollection(this.states);
    }
}

