/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.tennis;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.feed.api.TimeType;

public class TennisTimeType
implements TimeType,
Comparable<TimeType> {
    private final int match;
    private final int set;
    private final int game;
    private final String name;
    private static final Pattern namePattern = Pattern.compile("(M\\d+)?(S\\d+)?(G\\d+)?");

    public TennisTimeType(int match, int set, int game) {
        this.match = match;
        this.set = set;
        this.game = game;
        this.name = this.formatName(match, set, game);
    }

    public int match() {
        return this.match;
    }

    public int set() {
        return this.set;
    }

    public int game() {
        return this.game;
    }

    private String formatName(int match, int set, int game) {
        StringBuilder sb = new StringBuilder();
        if (match != 0) {
            sb.append("M" + match);
        }
        if (set != 0) {
            sb.append("S" + set);
        }
        if (game != 0) {
            sb.append("G" + game);
        }
        if ("M1".equals(sb.toString())) {
            return "FT";
        }
        if (sb.length() == 0) {
            return "M0S0G0";
        }
        return sb.toString();
    }

    @Override
    public int ordinal() {
        return this.hashCode();
    }

    @Override
    public String name() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.match;
        result = 31 * result + this.set;
        result = 31 * result + this.game;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TennisTimeType other = (TennisTimeType)obj;
        if (this.game != other.game) {
            return false;
        }
        if (this.match != other.match) {
            return false;
        }
        return this.set == other.set;
    }

    @Override
    public int compareTo(TimeType timeType) {
        return this.hashCode() - timeType.hashCode();
    }

    @Override
    public SportType sportType() {
        return SportType.TENNIS;
    }

    public static TennisTimeType valueOf(String name) {
        int match = 0;
        int set = 0;
        int game = 0;
        if ("FT".equals(name)) {
            match = 1;
        } else {
            Matcher matcher = namePattern.matcher(name);
            if (matcher.find()) {
                block5: for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String output = matcher.group(i);
                    if (output == null) continue;
                    int value = Integer.parseInt(output.substring(1));
                    switch (output.charAt(0)) {
                        case 'M': {
                            match = value;
                            continue block5;
                        }
                        case 'S': {
                            set = value;
                            continue block5;
                        }
                        case 'G': {
                            game = value;
                        }
                    }
                }
            }
        }
        return new TennisTimeType(match, set, game);
    }
}

