/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.record;

import jayeson.lib.record.EventStatus;
import jayeson.lib.record.PivotBias;
import jayeson.lib.record.PivotType;
import jayeson.lib.record.RateLine;
import jayeson.lib.record.Record;
import jayeson.lib.record.RecordMonitorTargetType;
import jayeson.lib.record.Utility;

public class MetaRecord {
    public static final float INVALID_SPREAD_VALUE = Float.MAX_VALUE;
    public static float INVALID_HDP_VALUE = Float.MAX_VALUE;
    public static float INVALID_OU_VALUE = Float.MAX_VALUE;
    private long _expireTime;
    private long _metaRecordCreatedTime;
    private Record _record;
    private String _remappedHost;
    private String _remappedGuest;
    private String _remappedMajorCategory;
    private float _lastRateOver;
    private float _lastRateUnder;
    private long _rateOverChangedTime;
    private long _rateUnderChangedTime;
    private float _pivotInFloat;
    private float _initialHdpFT;
    private float _initialOuFT;
    private float _initialHdpSpreadFT;
    private float _initialOuSpreadFT;
    private float _initialHdpHT;
    private float _initialOuHT;
    private float _initialHdpSpreadHT;
    private float _initialOuSpreadHT;

    public MetaRecord(Record r) {
        this._record = r;
        this._lastRateOver = 0.0f;
        this._lastRateUnder = 0.0f;
        this._rateOverChangedTime = 0L;
        this._rateUnderChangedTime = 0L;
        this._initialHdpSpreadFT = INVALID_HDP_VALUE;
        this._initialOuSpreadFT = Float.MAX_VALUE;
        this._initialOuFT = INVALID_OU_VALUE;
        this._initialHdpFT = INVALID_HDP_VALUE;
        this._initialHdpSpreadHT = INVALID_HDP_VALUE;
        this._initialOuSpreadHT = Float.MAX_VALUE;
        this._initialOuHT = INVALID_OU_VALUE;
        this._initialHdpHT = INVALID_HDP_VALUE;
        this._remappedHost = "";
        this._remappedGuest = "";
        this._remappedMajorCategory = "";
        if (r.pivotValue != null && !r.pivotValue.isEmpty()) {
            this._pivotInFloat = Utility.computePivotValueFromString(r.pivotValue);
        }
        this.setMetaRecordCreatedTime(System.currentTimeMillis());
    }

    private MetaRecord() {
    }

    public final MetaRecord deepCopy() {
        MetaRecord copy = new MetaRecord();
        copy._record = this._record.deepCopy();
        copy._lastRateOver = this._lastRateOver;
        copy._lastRateUnder = this._lastRateUnder;
        copy._rateOverChangedTime = this._rateOverChangedTime;
        copy._rateUnderChangedTime = this._rateUnderChangedTime;
        copy._remappedHost = this._remappedHost;
        copy._remappedGuest = this._remappedGuest;
        copy._remappedMajorCategory = this._remappedMajorCategory;
        copy._pivotInFloat = this._pivotInFloat;
        copy._initialHdpFT = this._initialHdpFT;
        copy._initialOuFT = this._initialOuFT;
        copy._initialHdpSpreadFT = this._initialHdpSpreadFT;
        copy._initialOuSpreadFT = this._initialOuSpreadFT;
        copy.setInitialHdpHT(this.getInitialHdpHT());
        copy.setInitialOuHT(this.getInitialOuHT());
        copy.setInitialHdpSpreadHT(this.getInitialHdpSpreadHT());
        copy.setInitialOuSpreadHT(this.getInitialOuSpreadHT());
        return copy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Market = ").append((Object)this._record.market).append(";");
        builder.append("EventMinorCategory = ").append((Object)this._record.eventMinorCategory).append(";");
        builder.append("EventUid = ").append(this._record.eventUid).append(";");
        builder.append("PivotType = ").append((Object)this._record.pivotType).append(";");
        builder.append("PivotValue = ").append(this._record.pivotValue).append(";");
        builder.append("Source = ").append(this._record.source).append(";");
        builder.append("EventStatus = ").append(this._record.eventStatus).append(";");
        return builder.toString();
    }

    public final void update(String eventUid, EventStatus eventStatus, float rateOver, float rateUnder) {
        if (this._record.rateOver != rateOver && this._record.rateUnder != rateUnder) {
            this._rateOverChangedTime = this._rateUnderChangedTime = System.currentTimeMillis();
        } else if (this._record.rateOver != rateOver) {
            this._rateOverChangedTime = System.currentTimeMillis();
            this._lastRateOver = this._record.rateOver;
        } else if (this._record.rateUnder != rateUnder) {
            this._rateUnderChangedTime = System.currentTimeMillis();
            this._lastRateUnder = this._record.rateUnder;
        }
        if (this._record.source.toLowerCase().equalsIgnoreCase("ibc") && !eventUid.equals("")) {
            this._record.eventUid = eventUid;
        }
        this._record.eventStatus = eventStatus;
        this._record.rateOver = rateOver;
        this._record.rateUnder = rateUnder;
    }

    public final Record getRecord() {
        return this._record;
    }

    public final long getRateOverChangedTime() {
        return this._rateOverChangedTime;
    }

    public final long getRateUnderChangedTime() {
        return this._rateUnderChangedTime;
    }

    public final float getLastRateOver() {
        return this._lastRateOver;
    }

    public final float getLastRateUnder() {
        return this._lastRateUnder;
    }

    public final boolean hasSpread() {
        return this._record.pivotType == PivotType.HDP || this._record.pivotType == PivotType.TOTAL;
    }

    public final float getSpread() {
        if (this._record == null) {
            return Float.MAX_VALUE;
        }
        float spread = 0.0f;
        spread = this._record.rateOver >= 1.0f && this._record.rateUnder < 1.0f ? -1.0f / this._record.rateOver + this._record.rateUnder : (this._record.rateOver < 1.0f && this._record.rateUnder >= 1.0f ? this._record.rateOver - 1.0f / this._record.rateUnder : (this._record.rateOver < 1.0f && this._record.rateUnder < 1.0f ? this._record.rateOver + this._record.rateUnder - 2.0f : Float.MAX_VALUE));
        return Math.abs(spread);
    }

    public float getPivotInFloat() {
        return this._pivotInFloat;
    }

    public void setPivotInFloat(float pivotInFloat) {
        this._pivotInFloat = pivotInFloat;
    }

    public final long getExpireTime() {
        return this._expireTime;
    }

    public final void setExpireTime(long expireTime) {
        this._expireTime = expireTime;
    }

    public long getCreateTime() {
        return this._record.createdTime;
    }

    public String getRemappedHost() {
        return this._remappedHost;
    }

    public void setRemappedHost(String remappedHost) {
        this._remappedHost = remappedHost;
    }

    public String getRemappedGuest() {
        return this._remappedGuest;
    }

    public void setRemappedGuest(String remappedGuest) {
        this._remappedGuest = remappedGuest;
    }

    public String getRemappedMajorCategory() {
        return this._remappedMajorCategory;
    }

    public void setRemappedMajorCategory(String remappedMajorCategory) {
        this._remappedMajorCategory = remappedMajorCategory;
    }

    public RateLine getRateLine(RecordMonitorTargetType target) {
        Record r = this.getRecord();
        switch (target) {
            case MONITOR_OVER_FT: 
            case MONITOR_OVER_HT: {
                if (r.pivotType != PivotType.TOTAL) {
                    return RateLine.NONE;
                }
                return RateLine.OVER_LINE;
            }
            case MONITOR_ONE_FT: 
            case MONITOR_ONE_HT: {
                if (r.pivotType != PivotType.ONE_TWO) {
                    return RateLine.NONE;
                }
                return RateLine.OVER_LINE;
            }
            case MONITOR_UNDER_FT: 
            case MONITOR_UNDER_HT: {
                if (r.pivotType != PivotType.TOTAL) {
                    return RateLine.NONE;
                }
                return RateLine.UNDER_LINE;
            }
            case MONITOR_TWO_FT: 
            case MONITOR_TWO_HT: {
                if (r.pivotType != PivotType.ONE_TWO) {
                    return RateLine.NONE;
                }
                return RateLine.UNDER_LINE;
            }
            case MONITOR_GIVE_FT: 
            case MONITOR_GIVE_HT: {
                if (r.pivotType != PivotType.HDP) {
                    return RateLine.NONE;
                }
                if (r.pivotBias == PivotBias.HOST) {
                    return RateLine.OVER_LINE;
                }
                if (r.pivotBias == PivotBias.GUEST) {
                    return RateLine.UNDER_LINE;
                }
                if (r.pivotBias == PivotBias.NEUTRAL) {
                    if (r.rateOver > r.rateUnder) {
                        return RateLine.UNDER_LINE;
                    }
                    return RateLine.OVER_LINE;
                }
            }
            case MONITOR_TAKE_FT: 
            case MONITOR_TAKE_HT: {
                if (r.pivotType != PivotType.HDP) {
                    return RateLine.NONE;
                }
                if (r.pivotBias == PivotBias.HOST) {
                    return RateLine.UNDER_LINE;
                }
                if (r.pivotBias == PivotBias.GUEST) {
                    return RateLine.OVER_LINE;
                }
                if (r.pivotBias == PivotBias.NEUTRAL) {
                    if (r.rateOver > r.rateUnder) {
                        return RateLine.OVER_LINE;
                    }
                    return RateLine.UNDER_LINE;
                }
            }
            case MONITOR_DRAW_FT: 
            case MONITOR_DRAW_HT: {
                if (r.pivotType != PivotType.ONE_TWO) {
                    return RateLine.NONE;
                }
                return RateLine.EQUAL_LINE;
            }
        }
        return RateLine.NONE;
    }

    public float getTargetRate(RecordMonitorTargetType target) {
        Record r = this.getRecord();
        switch (this.getRateLine(target)) {
            case OVER_LINE: {
                return r.rateOver;
            }
            case UNDER_LINE: {
                return r.rateUnder;
            }
            case EQUAL_LINE: {
                return r.rateEqual;
            }
            case NONE: {
                return -1000.0f;
            }
        }
        return -1000.0f;
    }

    public float getOppositeTargetRate(RecordMonitorTargetType target) {
        Record r = this.getRecord();
        switch (this.getRateLine(target)) {
            case OVER_LINE: {
                return r.rateUnder;
            }
            case UNDER_LINE: {
                return r.rateOver;
            }
            case EQUAL_LINE: {
                return r.rateEqual;
            }
            case NONE: {
                return -1000.0f;
            }
        }
        return -1000.0f;
    }

    public String getTargetUid(RecordMonitorTargetType target) {
        Record r = this.getRecord();
        switch (this.getRateLine(target)) {
            case OVER_LINE: {
                return r.rateOverUid;
            }
            case UNDER_LINE: {
                return r.rateUnderUid;
            }
            case EQUAL_LINE: {
                return r.rateEqualUid;
            }
            case NONE: {
                return "";
            }
        }
        return "";
    }

    public String getTeamFromTarget(RecordMonitorTargetType target) {
        switch (this.getRateLine(target)) {
            case OVER_LINE: {
                return "home";
            }
            case UNDER_LINE: {
                return "away";
            }
            case EQUAL_LINE: {
                return "draw";
            }
            case NONE: {
                return "";
            }
        }
        return "";
    }

    public final float getInitialHdpFT() {
        return this._initialHdpFT;
    }

    public void setInitialHdpFT(float initialHdpFT) {
        this._initialHdpFT = initialHdpFT;
    }

    public final boolean hasInitialHdpFT() {
        return this._initialHdpFT != INVALID_HDP_VALUE;
    }

    public float getInitialOuFT() {
        return this._initialOuFT;
    }

    public void setInitialOuFT(float initialOuFT) {
        this._initialOuFT = initialOuFT;
    }

    public final boolean hasInitialOuFT() {
        return this._initialOuFT != INVALID_OU_VALUE;
    }

    public float getInitialHdpSpreadFT() {
        return this._initialHdpSpreadFT;
    }

    public void setInitialHdpSpreadFT(float initialHdpSpreadFT) {
        this._initialHdpSpreadFT = initialHdpSpreadFT;
    }

    public final boolean hasInitialHdpSpreadFT() {
        return this._initialHdpSpreadFT != Float.MAX_VALUE;
    }

    public float getInitialOuSpreadFT() {
        return this._initialOuSpreadFT;
    }

    public void setInitialOuSpreadFT(float initialOuSpreadFT) {
        this._initialOuSpreadFT = initialOuSpreadFT;
    }

    public final boolean hasInitialOuSpreadFT() {
        return this._initialOuSpreadFT != Float.MAX_VALUE;
    }

    public float getInitialHdpHT() {
        return this._initialHdpHT;
    }

    public void setInitialHdpHT(float initialHdpHT) {
        this._initialHdpHT = initialHdpHT;
    }

    public final boolean hasInitialHdpHT() {
        return this._initialHdpHT != INVALID_HDP_VALUE;
    }

    public float getInitialOuHT() {
        return this._initialOuHT;
    }

    public void setInitialOuHT(float initialOuHT) {
        this._initialOuHT = initialOuHT;
    }

    public final boolean hasInitialOuHT() {
        return this._initialOuHT != INVALID_OU_VALUE;
    }

    public float getInitialHdpSpreadHT() {
        return this._initialHdpSpreadHT;
    }

    public void setInitialHdpSpreadHT(float initialHdpSpreadHT) {
        this._initialHdpSpreadHT = initialHdpSpreadHT;
    }

    public final boolean hasInitialHdpSpreadHT() {
        return this._initialHdpSpreadHT != Float.MAX_VALUE;
    }

    public float getInitialOuSpreadHT() {
        return this._initialOuSpreadHT;
    }

    public void setInitialOuSpreadHT(float initialOuSpreadHT) {
        this._initialOuSpreadHT = initialOuSpreadHT;
    }

    public final boolean hasInitialOuSpreadHT() {
        return this._initialOuSpreadHT != Float.MAX_VALUE;
    }

    public long getMetaRecordCreatedTime() {
        return this._metaRecordCreatedTime;
    }

    public void setMetaRecordCreatedTime(long _metaRecordCreatedTime) {
        this._metaRecordCreatedTime = _metaRecordCreatedTime;
    }
}

