/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.record;

import java.util.TreeMap;

public enum RecordMonitorMarketType {
    MONITOR_LIVE(0, "LIVE"),
    MONITOR_TODAY(1, "TODAY"),
    MONITOR_EARLY(2, "EARLY");

    private int _value;
    private String _display;
    private static final TreeMap<Integer, RecordMonitorMarketType> _map;

    private RecordMonitorMarketType(int value, String display) {
        this._value = value;
        this._display = display;
    }

    public int value() {
        return this._value;
    }

    public String dispText() {
        return this._display;
    }

    public String display() {
        return this._display;
    }

    public static int getNumOfValues() {
        return _map.size();
    }

    public static String getDispTextFromInt(int value) {
        return RecordMonitorMarketType.fromInt(value).dispText();
    }

    public static RecordMonitorMarketType fromInt(int value) {
        return _map.get(value);
    }

    static {
        _map = new TreeMap();
        for (RecordMonitorMarketType targetType : RecordMonitorMarketType.values()) {
            _map.put(new Integer(targetType.value()), targetType);
        }
    }
}

