/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.record;

import java.util.TreeMap;
import jayeson.lib.record.EventMinorCategory;
import jayeson.lib.record.PivotType;

public enum RecordMonitorTargetType {
    MONITOR_OVER_FT(0, "OVER FT", PivotType.TOTAL),
    MONITOR_UNDER_FT(1, "UNDER FT", PivotType.TOTAL),
    MONITOR_GIVE_FT(2, "GIVE FT", PivotType.HDP),
    MONITOR_TAKE_FT(3, "TAKE FT", PivotType.HDP),
    MONITOR_ONE_FT(4, "ONE FT", PivotType.ONE_TWO),
    MONITOR_TWO_FT(5, "TWO FT", PivotType.ONE_TWO),
    MONITOR_DRAW_FT(6, "DRAW FT", PivotType.ONE_TWO),
    MONITOR_OVER_HT(7, "OVER HT", PivotType.TOTAL),
    MONITOR_UNDER_HT(8, "UNDER HT", PivotType.TOTAL),
    MONITOR_GIVE_HT(9, "GIVE HT", PivotType.HDP),
    MONITOR_TAKE_HT(10, "TAKE HT", PivotType.HDP),
    MONITOR_ONE_HT(11, "ONE HT", PivotType.ONE_TWO),
    MONITOR_TWO_HT(12, "TWO HT", PivotType.ONE_TWO),
    MONITOR_DRAW_HT(13, "DRAW HT", PivotType.ONE_TWO);

    private int _value;
    private String _display;
    private PivotType _pivotType;
    private static final TreeMap<Integer, RecordMonitorTargetType> _map;

    private RecordMonitorTargetType(int value, String display, PivotType pivotType) {
        this._value = value;
        this._display = display;
        this._pivotType = pivotType;
    }

    public int value() {
        return this._value;
    }

    public String dispText() {
        return this._display;
    }

    public String display() {
        return this._display;
    }

    public PivotType pivotType() {
        return this._pivotType;
    }

    public EventMinorCategory eventMinorCategory() {
        return this.value() < MONITOR_OVER_HT.value() ? EventMinorCategory.FULL_TIME : EventMinorCategory.HALF_TIME;
    }

    public static int getNumOfValues() {
        return _map.size();
    }

    public static String getDispTextFromInt(int value) {
        return RecordMonitorTargetType.fromInt(value).dispText();
    }

    public static RecordMonitorTargetType fromInt(int value) {
        return _map.get(value);
    }

    static {
        _map = new TreeMap();
        for (RecordMonitorTargetType targetType : RecordMonitorTargetType.values()) {
            _map.put(new Integer(targetType.value()), targetType);
        }
    }
}

