/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import akka.stream.Materializer;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.Environment;
import play.inject.Binding;
import play.inject.Module;
import play.libs.ws.WSClient;
import play.libs.ws.ahc.AhcWSClient;
import play.libs.ws.ahc.StandaloneAhcWSClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;

public class AhcWSModule
extends Module {
    public List<Binding<?>> bindings(Environment environment, Config config) {
        return Collections.singletonList(AhcWSModule.bindClass(WSClient.class).toProvider(AhcWSClientProvider.class));
    }

    @Singleton
    public static class AhcWSClientProvider
    implements Provider<WSClient> {
        private final AhcWSClient client;

        @Inject
        public AhcWSClientProvider(AsyncHttpClient asyncHttpClient, Materializer materializer) {
            this.client = new AhcWSClient(new StandaloneAhcWSClient(asyncHttpClient, materializer), materializer);
        }

        public WSClient get() {
            return this.client;
        }
    }
}

