/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import akka.stream.javadsl.Source;
import akka.util.ByteString;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.w3c.dom.Document;
import play.libs.ws.BodyWritable;
import play.libs.ws.DefaultWSCookie;
import play.libs.ws.StandaloneWSRequest;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.WSAuthInfo;
import play.libs.ws.WSAuthScheme;
import play.libs.ws.WSBodyWritables;
import play.libs.ws.WSCookie;
import play.libs.ws.WSRequest;
import play.libs.ws.WSRequestFilter;
import play.libs.ws.WSResponse;
import play.libs.ws.WSSignatureCalculator;
import play.libs.ws.ahc.AhcWSClient;
import play.libs.ws.ahc.AhcWSResponse;
import play.libs.ws.ahc.StandaloneAhcWSRequest;
import play.mvc.Http;

public class AhcWSRequest
implements WSRequest {
    private static WSBodyWritables writables = new WSBodyWritables(){};
    private final AhcWSClient client;
    private final StandaloneAhcWSRequest request;
    private final Function<StandaloneWSResponse, WSResponse> responseFunction = AhcWSResponse::new;
    private final Function<StandaloneWSRequest, WSRequest> converter = new Function<StandaloneWSRequest, WSRequest>(){

        @Override
        public WSRequest apply(StandaloneWSRequest standaloneWSRequest) {
            StandaloneAhcWSRequest standaloneAhcWSRequest = (StandaloneAhcWSRequest)standaloneWSRequest;
            return new AhcWSRequest(AhcWSRequest.this.client, standaloneAhcWSRequest);
        }
    };

    AhcWSRequest(AhcWSClient ahcWSClient, StandaloneAhcWSRequest standaloneAhcWSRequest) {
        this.client = ahcWSClient;
        this.request = standaloneAhcWSRequest;
    }

    public CompletionStage<WSResponse> get() {
        return this.request.get().thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> patch(BodyWritable bodyWritable) {
        return this.request.patch(bodyWritable).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> patch(String string) {
        return this.request.patch(writables.body(string)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> patch(JsonNode jsonNode) {
        return this.request.patch(writables.body(jsonNode)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> patch(Document document) {
        return this.request.patch(writables.body(document)).thenApply(this.responseFunction);
    }

    @Deprecated
    public CompletionStage<WSResponse> patch(InputStream inputStream) {
        return this.request.patch(writables.body(() -> inputStream)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> patch(File file) {
        return this.request.patch(writables.body(file)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> patch(Source<? super Http.MultipartFormData.Part<Source<ByteString, ?>>, ?> source) {
        return this.request.patch((BodyWritable)writables.multipartBody(source)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> post(BodyWritable bodyWritable) {
        return this.request.post(bodyWritable).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> post(String string) {
        return this.request.post(writables.body(string)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> post(JsonNode jsonNode) {
        return this.request.post(writables.body(jsonNode)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> post(Document document) {
        return this.request.post(writables.body(document)).thenApply(this.responseFunction);
    }

    @Deprecated
    public CompletionStage<WSResponse> post(InputStream inputStream) {
        return this.request.post(writables.body(() -> inputStream)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> post(File file) {
        return this.request.post(writables.body(file)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> post(Source<? super Http.MultipartFormData.Part<Source<ByteString, ?>>, ?> source) {
        return this.request.post((BodyWritable)writables.multipartBody(source)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> put(BodyWritable bodyWritable) {
        return this.request.put(bodyWritable).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> put(String string) {
        return this.request.put(writables.body(string)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> put(JsonNode jsonNode) {
        return this.request.put(writables.body(jsonNode)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> put(Document document) {
        return this.request.put(writables.body(document)).thenApply(this.responseFunction);
    }

    @Deprecated
    public CompletionStage<WSResponse> put(InputStream inputStream) {
        return this.request.put(writables.body(() -> inputStream)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> put(File file) {
        return this.request.put(writables.body(file)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> put(Source<? super Http.MultipartFormData.Part<Source<ByteString, ?>>, ?> source) {
        return this.request.put((BodyWritable)writables.multipartBody(source)).thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> delete() {
        return this.request.delete().thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> head() {
        return this.request.head().thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> options() {
        return this.request.options().thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> execute(String string) {
        return this.request.setMethod(string).execute().thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> execute() {
        return this.request.execute().thenApply(this.responseFunction);
    }

    public CompletionStage<WSResponse> stream() {
        return this.request.stream().thenApply(this.responseFunction);
    }

    public WSRequest setMethod(String string) {
        return this.converter.apply((StandaloneWSRequest)this.request.setMethod(string));
    }

    public WSRequest setBody(BodyWritable bodyWritable) {
        return this.converter.apply((StandaloneWSRequest)this.request.setBody(bodyWritable));
    }

    public WSRequest setBody(String string) {
        return this.converter.apply((StandaloneWSRequest)this.request.setBody(writables.body(string)));
    }

    public WSRequest setBody(JsonNode jsonNode) {
        return this.converter.apply((StandaloneWSRequest)this.request.setBody(writables.body(jsonNode)));
    }

    @Deprecated
    public WSRequest setBody(InputStream inputStream) {
        return this.converter.apply((StandaloneWSRequest)this.request.setBody(writables.body(() -> inputStream)));
    }

    public WSRequest setBody(File file) {
        return this.converter.apply((StandaloneWSRequest)this.request.setBody(writables.body(file)));
    }

    public <U> WSRequest setBody(Source<ByteString, U> source) {
        return this.converter.apply((StandaloneWSRequest)this.request.setBody(writables.body(source)));
    }

    @Deprecated
    public WSRequest setHeader(String string, String string2) {
        return this.converter.apply((StandaloneWSRequest)this.request.addHeader(string, string2));
    }

    public WSRequest setHeaders(Map<String, List<String>> map) {
        return this.converter.apply((StandaloneWSRequest)this.request.setHeaders(map));
    }

    public WSRequest addHeader(String string, String string2) {
        return this.converter.apply((StandaloneWSRequest)this.request.addHeader(string, string2));
    }

    public WSRequest setQueryString(String string) {
        return this.converter.apply((StandaloneWSRequest)this.request.setQueryString(string));
    }

    @Deprecated
    public WSRequest setQueryParameter(String string, String string2) {
        return this.converter.apply((StandaloneWSRequest)this.request.addQueryParameter(string, string2));
    }

    public WSRequest addQueryParameter(String string, String string2) {
        return this.converter.apply((StandaloneWSRequest)this.request.addQueryParameter(string, string2));
    }

    public WSRequest setQueryString(Map<String, List<String>> map) {
        return this.converter.apply((StandaloneWSRequest)this.request.setQueryString(map));
    }

    public StandaloneWSRequest setUrl(String string) {
        return (StandaloneWSRequest)this.converter.apply((StandaloneWSRequest)this.request.setUrl(string));
    }

    public WSRequest addCookie(WSCookie wSCookie) {
        return this.converter.apply((StandaloneWSRequest)this.request.addCookie(wSCookie));
    }

    public WSRequest addCookie(Http.Cookie cookie) {
        return this.converter.apply((StandaloneWSRequest)this.request.addCookie(this.asCookie(cookie)));
    }

    private WSCookie asCookie(Http.Cookie cookie) {
        return new DefaultWSCookie(cookie.name(), cookie.value(), cookie.domain(), cookie.path(), (Long)Optional.ofNullable(cookie.maxAge()).map(Integer::longValue).filter(l -> l > -1L).orElse(null), cookie.secure(), cookie.httpOnly());
    }

    public WSRequest addCookies(WSCookie ... wSCookieArray) {
        return this.converter.apply((StandaloneWSRequest)this.request.addCookies(wSCookieArray));
    }

    public WSRequest setCookies(List<WSCookie> list) {
        return this.converter.apply((StandaloneWSRequest)this.request.setCookies(list));
    }

    public WSRequest setAuth(String string) {
        return this.converter.apply((StandaloneWSRequest)this.request.setAuth(string));
    }

    public WSRequest setAuth(String string, String string2) {
        return this.converter.apply(this.request.setAuth(string, string2));
    }

    public WSRequest setAuth(String string, String string2, WSAuthScheme wSAuthScheme) {
        return this.converter.apply(this.request.setAuth(string, string2, wSAuthScheme));
    }

    public StandaloneWSRequest setAuth(WSAuthInfo wSAuthInfo) {
        return (StandaloneWSRequest)this.converter.apply((StandaloneWSRequest)this.request.setAuth(wSAuthInfo));
    }

    public WSRequest sign(WSSignatureCalculator wSSignatureCalculator) {
        return this.converter.apply((StandaloneWSRequest)this.request.sign(wSSignatureCalculator));
    }

    public WSRequest setFollowRedirects(boolean bl) {
        return this.converter.apply((StandaloneWSRequest)this.request.setFollowRedirects(bl));
    }

    public WSRequest setVirtualHost(String string) {
        return this.converter.apply((StandaloneWSRequest)this.request.setVirtualHost(string));
    }

    @Deprecated
    public WSRequest setRequestTimeout(long l) {
        Duration duration = l == -1L ? Duration.of(1L, ChronoUnit.YEARS) : Duration.ofMillis(l);
        return this.converter.apply((StandaloneWSRequest)this.request.setRequestTimeout(duration));
    }

    public WSRequest setRequestTimeout(Duration duration) {
        return this.converter.apply((StandaloneWSRequest)this.request.setRequestTimeout(duration));
    }

    public WSRequest setRequestFilter(WSRequestFilter wSRequestFilter) {
        return this.converter.apply((StandaloneWSRequest)this.request.setRequestFilter(wSRequestFilter));
    }

    public WSRequest setContentType(String string) {
        return this.converter.apply((StandaloneWSRequest)this.request.setContentType(string));
    }

    public Optional<WSAuthInfo> getAuth() {
        return this.request.getAuth();
    }

    public Optional<BodyWritable> getBody() {
        return this.request.getBody();
    }

    public Optional<WSSignatureCalculator> getCalculator() {
        return this.request.getCalculator();
    }

    public Optional<String> getContentType() {
        return this.request.getContentType();
    }

    public Optional<Boolean> getFollowRedirects() {
        return this.request.getFollowRedirects();
    }

    public String getUrl() {
        return this.request.getUrl();
    }

    public Map<String, List<String>> getHeaders() {
        return this.request.getHeaders();
    }

    public List<String> getHeaderValues(String string) {
        return this.request.getHeaderValues(string);
    }

    public Optional<String> getHeader(String string) {
        return this.request.getHeader(string);
    }

    public Optional<Duration> getRequestTimeout() {
        return this.request.getRequestTimeout();
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.request.getQueryParameters();
    }
}

