/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Forever$;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsSettings$;
import akka.io.dns.internal.ResolvConf;
import akka.io.dns.internal.ResolvConfParser$;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f!B\u0010!\u0005\u00012\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011U\u0002!\u0011!Q\u0001\nYBQ\u0001\u0011\u0001\u0005\u0002\u0005CqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004]\u0001\u0001\u0006I\u0001\u0013\u0005\b;\u0002\u0011\r\u0011\"\u0001_\u0011\u00199\u0007\u0001)A\u0005?\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007BB<\u0001A\u0003%!\u000eC\u0004y\u0001\t\u0007I\u0011A5\t\re\u0004\u0001\u0015!\u0003k\u0011\u0015Q\b\u0001\"\u0003|\u0011)\ti\u0001\u0001EC\u0002\u0013%\u0011q\u0002\u0005\n\u0003G\u0001!\u0019!C\u0001\u0003KA\u0001\"!\u000b\u0001A\u0003%\u0011q\u0005\u0005\n\u0003W\u0001!\u0019!C\u0001\u0003[A\u0001\"!\u000e\u0001A\u0003%\u0011q\u0006\u0005\n\u0003o\u0001!\u0019!C\u0001\u0003sAq!a\u000f\u0001A\u0003%a\u0010C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u001d9\u0011Q\r\u0011\t\u0002\u0005\u001ddAB\u0010!\u0011\u0003\tI\u0007\u0003\u0004A/\u0011\u0005\u00111\u000e\u0005\n\u0003[:\"\u0019!C\u0007\u0003_B\u0001\"!\u001e\u0018A\u00035\u0011\u0011\u000f\u0005\n\u0003o:\"\u0019!C\u0005\u0003sB\u0001\"a#\u0018A\u0003%\u00111\u0010\u0005\t\u0003\u001b;B\u0011\u0001\u0013\u0002\u0010\"A\u0011qS\f\u0005\u0002\u0011\nIJA\u0006E]N\u001cV\r\u001e;j]\u001e\u001c(BA\u0011#\u0003\r!gn\u001d\u0006\u0003G\u0011\n!![8\u000b\u0003\u0015\nA!Y6lCN\u0011\u0001a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rML8\u000f^3n\u0007\u0001\u0001\"\u0001M\u001a\u000e\u0003ER!A\r\u0013\u0002\u000b\u0005\u001cGo\u001c:\n\u0005Q\n$aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017!A2\u0011\u0005]rT\"\u0001\u001d\u000b\u0005eR\u0014AB2p]\u001aLwM\u0003\u0002<y\u0005AA/\u001f9fg\u00064WMC\u0001>\u0003\r\u0019w.\\\u0005\u0003\u007fa\u0012aaQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u0002C\t\u0016\u0003\"a\u0011\u0001\u000e\u0003\u0001BQ!L\u0002A\u0002=BQ!N\u0002A\u0002Y\n1BT1nKN+'O^3sgV\t\u0001\nE\u0002J#Rs!AS(\u000f\u0005-sU\"\u0001'\u000b\u00055s\u0013A\u0002\u001fs_>$h(C\u0001+\u0013\t\u0001\u0016&A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001b&\u0001\u0002'jgRT!\u0001U\u0015\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016a\u00018fi*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o]\u0001\r\u001d\u0006lWmU3sm\u0016\u00148\u000fI\u0001\u000f%\u0016\u001cx\u000e\u001c<f)&lWm\\;u+\u0005y\u0006C\u00011f\u001b\u0005\t'B\u00012d\u0003!!WO]1uS>t'B\u00013*\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003M\u0006\u0014aBR5oSR,G)\u001e:bi&|g.A\bSKN|GN^3US6,w.\u001e;!\u0003M\u0001vn]5uSZ,7)Y2iKB{G.[2z+\u0005Q\u0007CA6u\u001d\ta'O\u0004\u0002nc:\u0011a\u000e\u001d\b\u0003\u0017>L\u0011!J\u0005\u0003G\u0011J!!\t\u0012\n\u0005M\u0004\u0013aC\"bG\",\u0007k\u001c7jGfL!!\u001e<\u0003\u0017\r\u000b7\r[3Q_2L7-\u001f\u0006\u0003g\u0002\nA\u0003U8tSRLg/Z\"bG\",\u0007k\u001c7jGf\u0004\u0013a\u0005(fO\u0006$\u0018N^3DC\u000eDW\rU8mS\u000eL\u0018\u0001\u0006(fO\u0006$\u0018N^3DC\u000eDW\rU8mS\u000eL\b%\u0001\u0004hKR$F\u000f\u001c\u000b\u0003UrDQ! \u0007A\u0002y\fA\u0001]1uQB\u0019q0a\u0002\u000f\t\u0005\u0005\u00111\u0001\t\u0003\u0017&J1!!\u0002*\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011QA\u0015\u0002\u0015I,7o\u001c7w\u0007>tg-\u0006\u0002\u0002\u0012A)\u0001&a\u0005\u0002\u0018%\u0019\u0011QC\u0015\u0003\r=\u0003H/[8o!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fA\u0005A\u0011N\u001c;fe:\fG.\u0003\u0003\u0002\"\u0005m!A\u0003*fg>dgoQ8oM\u0006i1+Z1sG\"$u.\\1j]N,\"!a\n\u0011\u0007%\u000bf0\u0001\bTK\u0006\u00148\r\u001b#p[\u0006Lgn\u001d\u0011\u0002\u000b9#u\u000e^:\u0016\u0005\u0005=\u0002c\u0001\u0015\u00022%\u0019\u00111G\u0015\u0003\u0007%sG/\u0001\u0004O\t>$8\u000fI\u0001\u0013%\u0006tGm\\7TiJ\fG/Z4z\u001d\u0006lW-F\u0001\u007f\u0003M\u0011\u0016M\u001c3p[N#(/\u0019;fOft\u0015-\\3!\u0003-IGmR3oKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0003#\u0002\u0015\u0002D\u0005\u001d\u0013bAA#S\tIa)\u001e8di&|g\u000e\r\t\u0004Q\u0005%\u0013bAA&S\t)1\u000b[8si\u00069c-Y5m+:\f'\r\\3U_\u0012+G/\u001a:nS:,G)\u001a4bk2$h*Y7fg\u0016\u0014h/\u001a:t+\t\t\t\u0006E\u0002)\u0003'J1!!\u0016*\u0005\u001dqu\u000e\u001e5j]\u001eD3\u0001AA-!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0I\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0014Q\f\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018.A\u0006E]N\u001cV\r\u001e;j]\u001e\u001c\bCA\"\u0018'\t9r\u0005\u0006\u0002\u0002h\u0005yAI\\:GC2d'-Y2l!>\u0014H/\u0006\u0002\u0002r=\u0011\u00111O\u000f\u0002k\u0005\u0001BI\\:GC2d'-Y2l!>\u0014H\u000fI\u0001\u0012S:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001cXCAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003\u000bK\u0013\u0001B;uS2LA!!#\u0002\u0000\t)!+Z4fq\u0006\u0011\u0012N\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:!\u0003Y\u0001\u0018M]:f\u001d\u0006lWm]3sm\u0016\u0014\u0018\t\u001a3sKN\u001cHc\u0001+\u0002\u0012\"1\u00111S\u000fA\u0002y\f1a\u001d;sQ\ri\u0012\u0011L\u0001\u0016O\u0016$H)\u001a4bk2$h*Y7f'\u0016\u0014h/\u001a:t)\u0011\tY*a)\u0011\u000b\u0005u\u0015q\u0014%\u000e\u0005\u0005\r\u0015\u0002BAQ\u0003\u0007\u00131\u0001\u0016:z\u0011\u0015ic\u00041\u00010\u0001")
@InternalApi
public final class DnsSettings {
    private Option<ResolvConf> resolvConf;
    public final ExtendedActorSystem akka$io$dns$DnsSettings$$system;
    private final Config c;
    private final List<InetSocketAddress> NameServers;
    private final FiniteDuration ResolveTimeout;
    private final CachePolicy.CachePolicy PositiveCachePolicy;
    private final CachePolicy.CachePolicy NegativeCachePolicy;
    private final List<String> SearchDomains;
    private final int NDots;
    private final String RandomStrategyName;
    private volatile boolean bitmap$0;

    public List<InetSocketAddress> NameServers() {
        return this.NameServers;
    }

    public FiniteDuration ResolveTimeout() {
        return this.ResolveTimeout;
    }

    public CachePolicy.CachePolicy PositiveCachePolicy() {
        return this.PositiveCachePolicy;
    }

    public CachePolicy.CachePolicy NegativeCachePolicy() {
        return this.NegativeCachePolicy;
    }

    private CachePolicy.CachePolicy getTtl(String path) {
        String string = this.c.getString(path);
        switch (string == null ? 0 : string.hashCode()) {
            case -677662361: {
                if (!"forever".equals(string)) break;
                return CachePolicy$Forever$.MODULE$;
            }
            case 104712844: {
                if (!"never".equals(string)) break;
                return CachePolicy$Never$.MODULE$;
            }
        }
        Duration finiteTtl = Helpers$Requiring$.MODULE$.requiring$extension(Helpers$.MODULE$.Requiring(this.c.getDuration(path)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DnsSettings.$anonfun$getTtl$1(x$1)), (Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(71).append("akka.io.dns.").append(path).append(" must be 'default', 'forever', 'never' or positive duration").toString());
        return CachePolicy$Ttl$.MODULE$.fromPositive(finiteTtl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<ResolvConf> resolvConf$lzycompute() {
        DnsSettings dnsSettings = this;
        synchronized (dnsSettings) {
            None$ none$;
            if (this.bitmap$0) return this.resolvConf;
            File etcResolvConf = new File("/etc/resolv.conf");
            if (Helpers$.MODULE$.isWindows()) {
                none$ = None$.MODULE$;
            } else if (etcResolvConf.exists()) {
                Try<ResolvConf> parsed = ResolvConfParser$.MODULE$.parseFile(etcResolvConf);
                Try<ResolvConf> try_ = parsed;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ResolvConf value = (ResolvConf)success.value();
                    none$ = new Some((Object)value);
                } else {
                    if (!(try_ instanceof Failure)) throw new MatchError(try_);
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    LoggingAdapter log = Logging$.MODULE$.apply(this.akka$io$dns$DnsSettings$$system, DnsSettings.class, LogSource$.MODULE$.fromAnyClass());
                    if (log.isWarningEnabled()) {
                        log.error(exception, "Error parsing /etc/resolv.conf, ignoring.");
                    }
                    none$ = None$.MODULE$;
                }
            } else {
                none$ = None$.MODULE$;
            }
            this.resolvConf = none$;
            this.bitmap$0 = true;
            return this.resolvConf;
        }
    }

    private Option<ResolvConf> resolvConf() {
        if (!this.bitmap$0) {
            return this.resolvConf$lzycompute();
        }
        return this.resolvConf;
    }

    public List<String> SearchDomains() {
        return this.SearchDomains;
    }

    public int NDots() {
        return this.NDots;
    }

    public String RandomStrategyName() {
        return this.RandomStrategyName;
    }

    public Function0<Object> idGenerator() {
        String string = this.RandomStrategyName();
        String string2 = "NOT-IN-ANY-WAY-RANDOM-test-sequential";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new Function0.mcS.sp(null){
                private short akka$io$dns$DnsSettings$$anon$$lastId;

                public boolean apply$mcZ$sp() {
                    return Function0.apply$mcZ$sp$((Function0)this);
                }

                public byte apply$mcB$sp() {
                    return Function0.apply$mcB$sp$((Function0)this);
                }

                public char apply$mcC$sp() {
                    return Function0.apply$mcC$sp$((Function0)this);
                }

                public double apply$mcD$sp() {
                    return Function0.apply$mcD$sp$((Function0)this);
                }

                public float apply$mcF$sp() {
                    return Function0.apply$mcF$sp$((Function0)this);
                }

                public int apply$mcI$sp() {
                    return Function0.apply$mcI$sp$((Function0)this);
                }

                public long apply$mcJ$sp() {
                    return Function0.apply$mcJ$sp$((Function0)this);
                }

                public void apply$mcV$sp() {
                    Function0.apply$mcV$sp$((Function0)this);
                }

                public short akka$io$dns$DnsSettings$$anon$$lastId() {
                    return this.akka$io$dns$DnsSettings$$anon$$lastId;
                }

                public void akka$io$dns$DnsSettings$$anon$$lastId_$eq(short x$1) {
                    this.akka$io$dns$DnsSettings$$anon$$lastId = x$1;
                }

                public short apply() {
                    return this.apply$mcS$sp();
                }

                public String toString() {
                    return "NOT-IN-ANY-WAY-RANDOM-test-sequential";
                }

                public short apply$mcS$sp() {
                    this.akka$io$dns$DnsSettings$$anon$$lastId_$eq((short)(this.akka$io$dns$DnsSettings$$anon$$lastId() + 1));
                    return this.akka$io$dns$DnsSettings$$anon$$lastId();
                }
                {
                    Function0.$init$((Function0)this);
                    this.akka$io$dns$DnsSettings$$anon$$lastId = 0;
                }
            };
        }
        return new Function0.mcS.sp(this){
            private final SecureRandom akka$io$dns$DnsSettings$$anon$$rng;
            private final String toString;

            public boolean apply$mcZ$sp() {
                return Function0.apply$mcZ$sp$((Function0)this);
            }

            public byte apply$mcB$sp() {
                return Function0.apply$mcB$sp$((Function0)this);
            }

            public char apply$mcC$sp() {
                return Function0.apply$mcC$sp$((Function0)this);
            }

            public double apply$mcD$sp() {
                return Function0.apply$mcD$sp$((Function0)this);
            }

            public float apply$mcF$sp() {
                return Function0.apply$mcF$sp$((Function0)this);
            }

            public int apply$mcI$sp() {
                return Function0.apply$mcI$sp$((Function0)this);
            }

            public long apply$mcJ$sp() {
                return Function0.apply$mcJ$sp$((Function0)this);
            }

            public void apply$mcV$sp() {
                Function0.apply$mcV$sp$((Function0)this);
            }

            public SecureRandom akka$io$dns$DnsSettings$$anon$$rng() {
                return this.akka$io$dns$DnsSettings$$anon$$rng;
            }

            public short apply() {
                return this.apply$mcS$sp();
            }

            public String toString() {
                return this.toString;
            }

            public short apply$mcS$sp() {
                return (short)this.akka$io$dns$DnsSettings$$anon$$rng().nextInt();
            }
            {
                String string;
                block11: {
                    SecureRandom secureRandom;
                    block10: {
                        String string2;
                        block9: {
                            Function0.$init$((Function0)this);
                            string2 = $outer.RandomStrategyName();
                            switch (string2 == null ? 0 : string2.hashCode()) {
                                case 0: {
                                    if ("".equals(string2)) {
                                        break;
                                    }
                                    break block9;
                                }
                                case 722717498: {
                                    if ("SecureRandom".equals(string2)) {
                                        break;
                                    }
                                    break block9;
                                }
                                default: {
                                    break block9;
                                }
                            }
                            $outer.akka$io$dns$DnsSettings$$system.log().debug("Using platform default SecureRandom algorithm for DNS request IDs");
                            secureRandom = new SecureRandom();
                            break block10;
                        }
                        $outer.akka$io$dns$DnsSettings$$system.log().debug("Using {} SecureRandom algorithm for DNS request IDs", string2);
                        secureRandom = SecureRandom.getInstance(string2);
                    }
                    this.akka$io$dns$DnsSettings$$anon$$rng = secureRandom;
                    String string3 = $outer.RandomStrategyName();
                    switch (string3 == null ? 0 : string3.hashCode()) {
                        case 0: {
                            if (!"".equals(string3)) break;
                            string = "platform default SecureRandom algorithm";
                            break block11;
                        }
                    }
                    string = new StringBuilder(23).append(string3).append(" SecureRandom algorithm").toString();
                }
                this.toString = string;
            }
        };
    }

    public Nothing$ failUnableToDetermineDefaultNameservers() {
        throw new IllegalStateException("Unable to obtain default nameservers from JNDI or via reflection. Please set `akka.io.dns.async-dns.nameservers` explicitly in order to be able to resolve domain names. ");
    }

    public static final /* synthetic */ boolean $anonfun$getTtl$1(Duration x$1) {
        return !x$1.isNegative();
    }

    public DnsSettings(ExtendedActorSystem system, Config c) {
        int n;
        block22: {
            ConfigValueType configValueType;
            block21: {
                .colon.colon colon2;
                block20: {
                    ConfigValueType configValueType2;
                    block19: {
                        List list;
                        block18: {
                            ConfigValueType configValueType3;
                            block17: {
                                this.akka$io$dns$DnsSettings$$system = system;
                                this.c = c;
                                configValueType3 = c.getValue("nameservers").valueType();
                                if (!ConfigValueType.STRING.equals(configValueType3)) break block17;
                                String string = c.getString("nameservers");
                                switch (string == null ? 0 : string.hashCode()) {
                                    case 1544803905: {
                                        if (!"default".equals(string)) break;
                                        List osAddresses = (List)DnsSettings$.MODULE$.getDefaultNameServers(system).getOrElse((Function0 & Serializable)() -> this.failUnableToDetermineDefaultNameservers());
                                        if (osAddresses.isEmpty()) {
                                            throw this.failUnableToDetermineDefaultNameservers();
                                        }
                                        list = osAddresses;
                                        break block18;
                                    }
                                }
                                InetSocketAddress inetSocketAddress = DnsSettings$.MODULE$.parseNameserverAddress(string);
                                list = Nil$.MODULE$.$colon$colon((Object)inetSocketAddress);
                                break block18;
                            }
                            if (ConfigValueType.LIST.equals(configValueType3)) {
                                IndexedSeq userAddresses = (IndexedSeq)package$JavaConverters$.MODULE$.ListHasAsScala(c.getStringList("nameservers")).asScala().iterator().map((Function1 & Serializable)str -> DnsSettings$.MODULE$.parseNameserverAddress((String)str)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
                                Predef$.MODULE$.require(userAddresses.nonEmpty(), (Function0 & Serializable)() -> "nameservers can not be empty");
                                list = userAddresses.toList();
                            } else {
                                throw new IllegalArgumentException("Invalid type for nameservers. Must be a string or string list");
                            }
                        }
                        this.NameServers = list;
                        this.ResolveTimeout = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c.getDuration("resolve-timeout")));
                        this.PositiveCachePolicy = this.getTtl("positive-ttl");
                        this.NegativeCachePolicy = this.getTtl("negative-ttl");
                        configValueType2 = c.getValue("search-domains").valueType();
                        if (!ConfigValueType.STRING.equals(configValueType2)) break block19;
                        String string = c.getString("search-domains");
                        switch (string == null ? 0 : string.hashCode()) {
                            case 1544803905: {
                                if (!"default".equals(string)) break;
                                colon2 = (List)this.resolvConf().map((Function1 & Serializable)x$2 -> x$2.search()).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
                                break block20;
                            }
                        }
                        colon2 = new .colon.colon((Object)string, (List)Nil$.MODULE$);
                        break block20;
                    }
                    if (ConfigValueType.LIST.equals(configValueType2)) {
                        colon2 = package$JavaConverters$.MODULE$.ListHasAsScala(c.getStringList("search-domains")).asScala().toList();
                    } else {
                        throw new IllegalArgumentException("Invalid type for search-domains. Must be a string or string list.");
                    }
                }
                this.SearchDomains = colon2;
                configValueType = c.getValue("ndots").valueType();
                if (!ConfigValueType.STRING.equals(configValueType)) break block21;
                String string = c.getString("ndots");
                switch (string == null ? 0 : string.hashCode()) {
                    case 1544803905: {
                        if (!"default".equals(string)) break;
                        n = BoxesRunTime.unboxToInt((Object)this.resolvConf().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.ndots())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
                        break block22;
                    }
                }
                throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            }
            if (ConfigValueType.NUMBER.equals(configValueType)) {
                int ndots = c.getInt("ndots");
                if (ndots < 0) {
                    throw new IllegalArgumentException("Invalid value for ndots, ndots must not be negative.");
                }
                n = ndots;
            } else {
                throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            }
        }
        this.NDots = n;
        this.RandomStrategyName = c.getString("id-strategy");
    }
}

