/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Props;
import akka.actor.Props$;
import akka.annotation.InternalApi;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsResolver;
import akka.io.dns.internal.DnsClient;
import java.io.Serializable;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

@InternalApi
public final class AsyncDnsResolver$ {
    public static final AsyncDnsResolver$ MODULE$ = new AsyncDnsResolver$();
    private static final Regex ipv4Address = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}$"));
    private static final Regex ipv6Address = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$"));
    private static final Future<DnsClient.Answer> akka$io$dns$internal$AsyncDnsResolver$$Empty = Future$.MODULE$.successful((Object)new DnsClient.Answer(-1, (Seq<ResourceRecord>)((Seq)Seq$.MODULE$.empty()), (Seq<ResourceRecord>)((Seq)Seq$.MODULE$.empty())));
    private static final int MaxIdGenerationAttempts = 2 * Short.MAX_VALUE - 1;

    private Regex ipv4Address() {
        return ipv4Address;
    }

    private Regex ipv6Address() {
        return ipv6Address;
    }

    public boolean isIpv4Address(String name) {
        return this.ipv4Address().findAllMatchIn((CharSequence)name).nonEmpty();
    }

    public boolean isIpv6Address(String name) {
        return this.ipv6Address().findAllMatchIn((CharSequence)name).nonEmpty();
    }

    public boolean akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(String name) {
        return this.isIpv4Address(name) || this.isIpv6Address(name);
    }

    public Future<DnsClient.Answer> akka$io$dns$internal$AsyncDnsResolver$$Empty() {
        return akka$io$dns$internal$AsyncDnsResolver$$Empty;
    }

    public AsyncDnsResolver.ResolveFailedException akka$io$dns$internal$AsyncDnsResolver$$failToResolve(String name, List<InetSocketAddress> nameServers) {
        return new AsyncDnsResolver.ResolveFailedException(new StringBuilder(36).append("Failed to resolve ").append(name).append(" with nameservers ").append(nameServers).toString());
    }

    public Props akka$io$dns$internal$AsyncDnsResolver$$injectorProps(DnsSettings settings) {
        return Props$.MODULE$.apply((Function0 & Serializable)() -> new AsyncDnsResolver.RequestIdInjector(settings.idGenerator()), ClassTag$.MODULE$.apply(AsyncDnsResolver.RequestIdInjector.class));
    }

    public int MaxIdGenerationAttempts() {
        return MaxIdGenerationAttempts;
    }

    private AsyncDnsResolver$() {
    }
}

