/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;

public class AccessKeyGenerator {
    private static final int TIME_STEP = 60000;
    public static final String hashDateFormat = "yyyyHHMMssddmmZZZZZ";
    private static final DateFormat hashDateFormatter = new SimpleDateFormat("yyyyHHMMssddmmZZZZZ");

    public static String hashCredentialsWithDate(String username, String password) {
        return AccessKeyGenerator.hashCredentialsWithDate(username, password, new Date());
    }

    public static String hashCredentialsWithDate(String username, String password, Date date) {
        String dateString = AccessKeyGenerator.formatDate(date);
        return AccessKeyGenerator.hashCredentialsWithDate(username, password, dateString);
    }

    private static boolean verifyCredentialsWithDate(String username, String password, String dateWithDigest, int timeDiffInMin) {
        int timeDiffInMs = timeDiffInMin * 60 * 1000;
        try {
            String dateString = dateWithDigest.substring(0, hashDateFormat.length());
            Date clientDate = AccessKeyGenerator.parseDate(dateString);
            if (Math.abs(clientDate.getTime() - System.currentTimeMillis()) > (long)timeDiffInMs) {
                return false;
            }
            String serverDigest = AccessKeyGenerator.hashCredentialsWithDate(username, password, dateString);
            return dateWithDigest.equals(serverDigest);
        }
        catch (Exception err) {
            return false;
        }
    }

    public static String hashCredentialsWithDate(String username, String password, String dateString) {
        String message = username + "_" + password + "_" + dateString;
        try {
            byte[] bytesOfMessage = message.getBytes("utf-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] theDigest = md.digest(bytesOfMessage);
            String hexString = new String(Hex.encodeHex((byte[])theDigest));
            return dateString + hexString;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String formatDate(Date date) {
        try {
            String dateString = hashDateFormatter.format(date);
            return dateString;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Date parseDate(String dateString) {
        try {
            Date result = hashDateFormatter.parse(dateString);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean keyIsNewForm(String key) {
        if (key.length() != hashDateFormat.length() + 32) {
            return false;
        }
        try {
            hashDateFormatter.parse(key.substring(0, hashDateFormat.length()));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean keyIsClassicForm(String key) {
        if (key.length() != 32) {
            return false;
        }
        try {
            new BigInteger(key, 16);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean verifyTimedCredentials(String username, String password, String key, int threshold, String timeZone) {
        long currentTime = System.currentTimeMillis();
        for (int i = -threshold; i <= threshold; ++i) {
            String hash = AccessKeyGenerator.timedCredentials(username, password, new Date(currentTime + (long)(i * 60000)), timeZone);
            if (!hash.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyTimedCredentials(String username, String password, String key) {
        if (AccessKeyGenerator.keyIsNewForm(key)) {
            return AccessKeyGenerator.verifyCredentialsWithDate(username, password, key, 5);
        }
        if (AccessKeyGenerator.keyIsClassicForm(key)) {
            return AccessKeyGenerator.verifyTimedCredentials(username, password, key, 2, "GMT-0:00");
        }
        return false;
    }

    public static boolean verifyTimedCredentials(String username, String password, String key, int keyThreshold) {
        if (AccessKeyGenerator.keyIsNewForm(key)) {
            return AccessKeyGenerator.verifyCredentialsWithDate(username, password, key, 5);
        }
        if (AccessKeyGenerator.keyIsClassicForm(key)) {
            return AccessKeyGenerator.verifyTimedCredentials(username, password, key, keyThreshold, "GMT-0:00");
        }
        return false;
    }

    public static String timedCredentials(String username, String password) {
        return AccessKeyGenerator.timedCredentials(username, password, new Date(System.currentTimeMillis()), "GMT-0:00");
    }

    public static String timedCredentials(String username, String password, Date time, String timeZone) {
        StringBuilder builder = new StringBuilder();
        builder.append(username).append('_');
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        String date1 = dateFormat.format(time);
        builder.append(date1).append('_');
        builder.append(password).append('_');
        dateFormat = new SimpleDateFormat("HH/mm");
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        String date2 = dateFormat.format(time);
        builder.append(date2);
        try {
            byte[] bytesOfMessage = builder.toString().getBytes("utf-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] theDigest = md.digest(bytesOfMessage);
            String result = new String(Hex.encodeHex((byte[])theDigest));
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

