/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class Futures {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("FuturesTimeoutThread");
        return t;
    });

    private static <T> CompletableFuture<T> failAfter(Duration duration) {
        CompletableFuture promise = new CompletableFuture();
        scheduler.schedule(() -> {
            TimeoutException ex = new TimeoutException("Timeout after " + duration);
            return promise.completeExceptionally(ex);
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
        return promise;
    }

    public static <T> CompletableFuture<Collection<T>> toListFuture(Collection<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> CompletableFuture<Collection<T>> toListFuture(CompletableFuture<T> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(v -> Arrays.asList(futures).stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> timeout(CompletableFuture<T> future, Duration duration) {
        CompletableFuture result = new CompletableFuture();
        ((CompletableFuture)future.acceptEither((CompletionStage)Futures.failAfter(duration), r -> result.complete(r))).exceptionally(t -> {
            result.completeExceptionally((Throwable)t);
            return null;
        });
        return result;
    }
}

