/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.batch;

import java.util.List;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.batch.BaseSharedExecutorBatchWorker;
import jayeson.utility.concurrent.worker.batch.BatchTask;
import jayeson.utility.concurrent.worker.batch.BatchTaskProducer;

class BatchProcessor<D, V>
implements Runnable {
    private final BaseSharedExecutorBatchWorker<D, V> worker;
    private final BatchTaskProducer<D, V> taskProducer;

    public BatchProcessor(BaseSharedExecutorBatchWorker<D, V> worker, BatchTaskProducer<D, V> taskProducer) {
        this.worker = worker;
        this.taskProducer = taskProducer;
    }

    @Override
    public void run() {
        Function<List<D>, V> handler = this.worker.getDefaultHandler();
        List<D> data = this.worker.nextBatch();
        if (!data.isEmpty()) {
            BatchTask<D, V> task = this.taskProducer.produce(data, handler);
            task.execute(this);
        } else {
            this.worker.processorDone();
        }
    }

    public void next() {
        this.worker.next(this);
    }

    public BaseSharedExecutorBatchWorker<D, V> getWorker() {
        return this.worker;
    }
}

