/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.batch;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.batch.BaseBatchWorkerCallback;
import jayeson.utility.concurrent.worker.batch.BaseSharedExecutorBatchWorker;
import jayeson.utility.concurrent.worker.batch.BatchFutureTask;
import jayeson.utility.concurrent.worker.batch.BatchTask;

public class SharedExecutorBatchFutureWorker<T, U>
extends BaseSharedExecutorBatchWorker<T, CompletableFuture<U>> {
    private final boolean waitOnFuture;

    public SharedExecutorBatchFutureWorker(ScheduledExecutorService executor, Function<List<T>, CompletableFuture<U>> defaultHandler, int maxBatchSize, BatchWorkerCallback<T, U> callback) {
        this(executor, new ConcurrentLinkedQueue(), defaultHandler, maxBatchSize, callback, true);
    }

    public SharedExecutorBatchFutureWorker(ScheduledExecutorService executor, Function<List<T>, CompletableFuture<U>> defaultHandler, int maxBatchSize, BatchWorkerCallback<T, U> callback, boolean waitOnFuture) {
        this(executor, new ConcurrentLinkedQueue(), defaultHandler, maxBatchSize, callback, waitOnFuture);
    }

    public SharedExecutorBatchFutureWorker(ScheduledExecutorService executor, Queue<T> dataQueue, Function<List<T>, CompletableFuture<U>> defaultHandler, int maxBatchSize, BatchWorkerCallback<T, U> callback, boolean waitOnFuture) {
        super(executor, dataQueue, defaultHandler, maxBatchSize, callback);
        this.defaultHandler = defaultHandler;
        this.waitOnFuture = waitOnFuture;
    }

    public void submit(T message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null.");
        }
        this.dataQueue.offer(message);
        this.scheduleProcessor(null);
    }

    public void submit(List<T> messages) {
        if (messages == null) {
            throw new IllegalArgumentException("messages cannot be null.");
        }
        if (!messages.isEmpty()) {
            this.dataQueue.addAll(messages);
            this.scheduleProcessor(null);
        }
    }

    @Override
    public BatchTask<T, CompletableFuture<U>> produce(List<T> data, Function<List<T>, CompletableFuture<U>> handler) {
        return new BatchFutureTask(data, handler, this.batchWorkerCallback, this.waitOnFuture);
    }

    @FunctionalInterface
    public static interface BatchWorkerCallback<T, U>
    extends BaseBatchWorkerCallback<T, U, SharedExecutorBatchFutureWorker<T, U>> {
    }
}

