/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.single;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.single.Processor;
import jayeson.utility.concurrent.worker.single.Task;

class FutureTask<D, V>
extends Task<D, CompletableFuture<V>> {
    private final boolean waitOnFuture;

    public FutureTask(D data, Function<D, CompletableFuture<V>> func, CompletableFuture taskFuture, boolean waitOnFuture) {
        super(data, func, taskFuture);
        this.waitOnFuture = waitOnFuture;
    }

    @Override
    void execute(Processor processor) {
        try {
            CompletableFuture result = (CompletableFuture)this.func.apply(this.data);
            result.whenComplete((u, t) -> {
                try {
                    if (t != null) {
                        this.taskFuture.completeExceptionally((Throwable)t);
                    } else {
                        this.taskFuture.complete(u);
                    }
                }
                finally {
                    if (this.waitOnFuture) {
                        processor.next();
                    }
                }
            });
        }
        catch (Exception e) {
            this.taskFuture.completeExceptionally(e);
        }
        finally {
            if (!this.waitOnFuture) {
                processor.next();
            }
        }
    }
}

