/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.single;

import java.util.function.Function;
import jayeson.utility.concurrent.worker.single.BaseHandlerFactory;
import jayeson.utility.concurrent.worker.single.BaseSharedExecutorWorker;
import jayeson.utility.concurrent.worker.single.Task;

class Processor<D, V, T extends Task<D, V>, HF extends BaseHandlerFactory<D, V>>
implements Runnable {
    private final BaseSharedExecutorWorker<D, V, T, HF> worker;
    private final BaseHandlerFactory<D, V> defaultFuncSupplier;

    public Processor(BaseSharedExecutorWorker<D, V, T, HF> worker, BaseHandlerFactory<D, V> defaultFuncSupplier) {
        this.worker = worker;
        this.defaultFuncSupplier = defaultFuncSupplier;
    }

    @Override
    public void run() {
        Function<D, V> beforeDefaultHandler = this.worker.getDefaultHandler();
        HF beforeHandlerFactory = this.worker.getHandlerFactory();
        Task<D, V> task = this.worker.peek();
        Function<D, V> func = null;
        if (task != null) {
            func = task.getFunc();
            if (func == null) {
                func = this.defaultFuncSupplier.getHandler(task.getData());
                task.setFunc(func);
            }
            if (func != null) {
                this.worker.remove(task);
                task.execute(this);
            } else {
                boolean handlerSet;
                boolean bl = handlerSet = beforeDefaultHandler == null && beforeHandlerFactory == null && (this.worker.getDefaultHandler() != null || this.worker.getHandlerFactory() != null);
                if (handlerSet) {
                    this.next();
                } else {
                    this.worker.processorDone();
                }
            }
        } else {
            this.worker.processorDone();
        }
    }

    public void next() {
        this.worker.next(this);
    }
}

