/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.single;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.single.BaseHandlerFactory;
import jayeson.utility.concurrent.worker.single.BaseSharedExecutorWorker;
import jayeson.utility.concurrent.worker.single.FutureTask;

public class SharedExecutorFutureWorker<T, U>
extends BaseSharedExecutorWorker<T, CompletableFuture<U>, FutureTask<T, U>, HandlerFactory<T, U>> {
    private final boolean waitOnFuture;

    public SharedExecutorFutureWorker(ScheduledExecutorService executor) {
        this(executor, new ConcurrentLinkedQueue<FutureTask<T, U>>(), null, null, true);
    }

    public SharedExecutorFutureWorker(ScheduledExecutorService executor, Function<T, CompletableFuture<U>> defaultHandler, boolean waitOnFuture) {
        this(executor, new ConcurrentLinkedQueue<FutureTask<T, U>>(), defaultHandler, null, waitOnFuture);
    }

    public SharedExecutorFutureWorker(ScheduledExecutorService executor, HandlerFactory<T, U> handlerFactory, boolean waitOnFuture) {
        this(executor, new ConcurrentLinkedQueue<FutureTask<T, U>>(), null, handlerFactory, waitOnFuture);
    }

    public SharedExecutorFutureWorker(ScheduledExecutorService executor, Function<T, CompletableFuture<U>> defaultHandler, HandlerFactory<T, U> handlerFactory, boolean waitOnFuture) {
        this(executor, new ConcurrentLinkedQueue<FutureTask<T, U>>(), defaultHandler, handlerFactory, waitOnFuture);
    }

    SharedExecutorFutureWorker(ScheduledExecutorService executor, Queue<FutureTask<T, U>> taskQueue, Function<T, CompletableFuture<U>> defaultHandler, HandlerFactory<T, U> handlerFactory, boolean waitOnFuture) {
        super(executor, taskQueue, defaultHandler, handlerFactory);
        this.defaultHandler = defaultHandler;
        this.handlerFactory = handlerFactory;
        this.waitOnFuture = waitOnFuture;
    }

    public CompletableFuture<U> submit(T message, Function<T, CompletableFuture<U>> handler) {
        return this.submit(message, handler, false);
    }

    public CompletableFuture<U> submit(T message) {
        return this.submit(message, null, true);
    }

    @Override
    public Function<T, CompletableFuture<U>> getHandler(T data) {
        HandlerFactory currentHF = (HandlerFactory)this.handlerFactory;
        Function currentDH = this.defaultHandler;
        Function result = null;
        if (currentHF != null) {
            result = currentHF.getHandler(data);
        } else if (currentDH != null) {
            result = currentDH;
        }
        return result;
    }

    private CompletableFuture<U> submit(T message, Function<T, CompletableFuture<U>> handler, boolean allowNullHandler) {
        if (handler == null && !allowNullHandler) {
            throw new IllegalArgumentException("handler cannot be null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null.");
        }
        CompletableFuture taskResult = new CompletableFuture();
        FutureTask<T, U> newTask = new FutureTask<T, U>(message, handler, taskResult, this.waitOnFuture);
        this.taskQueue.offer(newTask);
        this.scheduleProcessor(null);
        return taskResult;
    }

    public static interface HandlerFactory<T, U>
    extends BaseHandlerFactory<T, CompletableFuture<U>> {
        @Override
        public Function<T, CompletableFuture<U>> getHandler(T var1);
    }
}

