/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.single;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.single.BaseHandlerFactory;
import jayeson.utility.concurrent.worker.single.BaseSharedExecutorWorker;
import jayeson.utility.concurrent.worker.single.Task;

public class SharedExecutorWorker<T, U>
extends BaseSharedExecutorWorker<T, U, Task<T, U>, HandlerFactory<T, U>> {
    public SharedExecutorWorker(ScheduledExecutorService executor) {
        this(executor, new ConcurrentLinkedQueue<Task<T, U>>(), null, null);
    }

    public SharedExecutorWorker(ScheduledExecutorService executor, Function<T, U> defaultHandler) {
        this(executor, new ConcurrentLinkedQueue<Task<T, U>>(), defaultHandler, null);
    }

    public SharedExecutorWorker(ScheduledExecutorService executor, HandlerFactory<T, U> handlerFactory) {
        this(executor, (Queue<Task<T, U>>)new ConcurrentLinkedQueue<Task<T, U>>(), (Function<T, U>)null, handlerFactory);
    }

    public SharedExecutorWorker(ScheduledExecutorService executor, Function<T, U> defaultHandler, HandlerFactory<T, U> handlerFactory) {
        this(executor, (Queue<Task<T, U>>)new ConcurrentLinkedQueue<Task<T, U>>(), defaultHandler, handlerFactory);
    }

    SharedExecutorWorker(ScheduledExecutorService executor, Queue<Task<T, U>> taskQueue, Function<T, U> defaultHandler, HandlerFactory<T, U> handlerFactory) {
        super(executor, taskQueue, defaultHandler, handlerFactory);
        this.defaultHandler = defaultHandler;
        this.handlerFactory = handlerFactory;
    }

    public CompletableFuture<U> submit(T message, Function<T, U> handler) {
        return this.submit(message, handler, false);
    }

    public CompletableFuture<U> submit(T message) {
        return this.submit(message, null, true);
    }

    @Override
    public Function<T, U> getHandler(T data) {
        HandlerFactory currentHF = (HandlerFactory)this.handlerFactory;
        Function currentDH = this.defaultHandler;
        Function result = null;
        if (currentHF != null) {
            result = currentHF.getHandler(data);
        } else if (currentDH != null) {
            result = currentDH;
        }
        return result;
    }

    private CompletableFuture<U> submit(T message, Function<T, U> handler, boolean allowNullHandler) {
        if (handler == null && !allowNullHandler) {
            throw new IllegalArgumentException("handler cannot be null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null.");
        }
        CompletableFuture taskResult = new CompletableFuture();
        Task<T, U> newTask = new Task<T, U>(message, handler, taskResult);
        this.taskQueue.offer(newTask);
        this.scheduleProcessor(null);
        return taskResult;
    }

    public static interface HandlerFactory<T, U>
    extends BaseHandlerFactory<T, U> {
        @Override
        public Function<T, U> getHandler(T var1);
    }
}

