/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.messages;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCounted;
import java.util.Arrays;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IPipelineConstructor;
import jayeson.lib.delivery.core.DeliveryCoreUtility;

public class EmptyMessageClass
implements IMessageClass<Object>,
IPipelineConstructor {
    private IMessageGroup messageGroup;
    static final Object dummyObject = new Object();
    private byte classId;
    private OutHandler outH;
    private InHandler inH;

    public EmptyMessageClass(IMessageGroup messageGroup, byte classId) {
        this.messageGroup = messageGroup;
        this.classId = classId;
        this.outH = new OutHandler();
        this.inH = new InHandler();
    }

    @Override
    public byte id() {
        return this.classId;
    }

    @Override
    public IMessageGroup group() {
        return this.messageGroup;
    }

    @Override
    public Class<Object> instanceClass() {
        return Object.class;
    }

    @Override
    public IPipelineConstructor constructor() {
        return this;
    }

    @Override
    public List<ChannelHandler> outboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.outH});
    }

    @Override
    public List<ChannelHandler> inboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.inH});
    }

    @ChannelHandler.Sharable
    private class OutHandler
    extends ChannelOutboundHandlerAdapter {
        private OutHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            ByteBuf buf = ctx.alloc().buffer(1);
            ctx.write((Object)buf, promise);
        }
    }

    @ChannelHandler.Sharable
    private class InHandler
    extends ChannelInboundHandlerAdapter {
        private InHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof ReferenceCounted) {
                DeliveryCoreUtility.release((ReferenceCounted)msg);
            }
            ctx.fireChannelRead(dummyObject);
        }
    }
}

