/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.messages;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.ReferenceCounted;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.DeliveryCoreUtility;
import jayeson.lib.delivery.core.messages.BaseMessageClass;
import jayeson.lib.delivery.core.messages.INettyHttpRequestConverter;

public class HttpRequestConverterMessageClass<T>
extends BaseMessageClass<T> {
    private INettyHttpRequestConverter<T> converter;
    private InHandler ih;
    private OutHandler oh;

    public HttpRequestConverterMessageClass(IMessageGroup group, Class<T> instanceClass, byte id, INettyHttpRequestConverter<T> converter) {
        super(instanceClass, group, id);
        this.converter = converter;
        this.ih = new InHandler();
        this.oh = new OutHandler();
    }

    @Override
    public List<ChannelHandler> inboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.ih});
    }

    @Override
    public List<ChannelHandler> outboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.oh});
    }

    @ChannelHandler.Sharable
    private class OutHandler
    extends ChannelOutboundHandlerAdapter {
        private OutHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg.getClass().isInstance(HttpRequestConverterMessageClass.this.instanceClass())) {
                FullHttpRequest converted = HttpRequestConverterMessageClass.this.converter.convert(msg);
                ctx.write((Object)converted);
            }
        }
    }

    @ChannelHandler.Sharable
    private class InHandler
    extends ChannelInboundHandlerAdapter {
        private InHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof FullHttpRequest) {
                Optional converted = HttpRequestConverterMessageClass.this.converter.convert((FullHttpRequest)msg);
                DeliveryCoreUtility.release((ReferenceCounted)((FullHttpRequest)msg));
                ctx.fireChannelRead(converted);
            }
        }
    }
}

