/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.concurrent.ThreadFactory;
import jayeson.lib.delivery.api.ServerConfig;
import jayeson.lib.delivery.core.UnSharableHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyBaseServer
extends ChannelInitializer<SocketChannel> {
    private static final String USE_MULTI_EVENTLOOP = "delivery.multiEventLoop";
    private static Logger log = LoggerFactory.getLogger(NettyBaseServer.class);
    protected ServerConfig config;
    protected DefaultChannelGroup channelGroup;
    protected EventLoopGroup bossGroup;
    protected EventLoopGroup workerGroup;
    private ChannelHandler defaultChannelListener;

    public NettyBaseServer(ServerConfig configuration) {
        this.config = configuration;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline channelPipeline = ch.pipeline();
        log.info("New connection for {} {}", (Object)ch.remoteAddress().getHostString(), (Object)ch.remoteAddress().getPort());
        if (this.defaultChannelListener == null) {
            log.error("No default channelHandler to add. Closing Channel");
            ch.close();
        } else {
            channelPipeline.addLast(new ChannelHandler[]{this.defaultChannelListener});
            log.info("Added Channel listener {}", this.defaultChannelListener.getClass());
            this.channelGroup.add((Channel)ch);
            log.info("Number of active connections {}", (Object)this.channelGroup.size());
        }
    }

    protected void startNettyServer() throws InterruptedException {
        if (this.channelGroup != null && !this.channelGroup.isEmpty()) {
            log.warn("Server already started and has active EndPoints. Restarting");
            this.stopNettyServer();
        }
        log.info("Starting Server on port {}", (Object)this.config.getPort());
        ServerBootstrap serverBootStrap = new ServerBootstrap();
        boolean multiEventLoop = Boolean.parseBoolean(System.getProperty(USE_MULTI_EVENTLOOP, "False"));
        int numLoops = 1;
        if (multiEventLoop) {
            numLoops = 0;
            log.info("MultiEventLoop is enabled. You can disable it by setting -D{}=false", (Object)USE_MULTI_EVENTLOOP);
        } else {
            log.info("MultiEventLoop is disabled. You can enable it by setting -D{}=true", (Object)USE_MULTI_EVENTLOOP);
        }
        this.bossGroup = new NioEventLoopGroup(numLoops, (ThreadFactory)new DefaultThreadFactory("delivery-server-boss-nioEventLoopGroup"));
        this.workerGroup = new NioEventLoopGroup(numLoops, (ThreadFactory)new DefaultThreadFactory("delivery-server-worker-nioEventLoopGroup"));
        this.channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        ((ServerBootstrap)((ServerBootstrap)serverBootStrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        serverBootStrap.bind(this.config.getPort()).sync();
    }

    protected void stopNettyServer() throws InterruptedException {
        log.info("Stopping server");
        if (this.channelGroup == null) {
            log.warn("Channel Group is nulll. Not attempting to close");
        } else {
            this.channelGroup.close().sync();
            this.bossGroup.shutdownGracefully().sync();
            this.workerGroup.shutdownGracefully().sync();
        }
    }

    protected void restartServer() throws InterruptedException {
        log.info("Restarting Server");
        this.stopNettyServer();
        this.startNettyServer();
    }

    public ServerConfig getConfig() {
        return this.config;
    }

    public DefaultChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public ChannelHandler getDefaultChannelListener() {
        return this.defaultChannelListener;
    }

    public void setDefaultChannelListener(ChannelHandler defaultChannelListener) throws UnSharableHandlerException {
        ChannelHandler.Sharable ann = defaultChannelListener.getClass().getAnnotation(ChannelHandler.Sharable.class);
        if (ann == null) {
            throw new UnSharableHandlerException();
        }
        this.defaultChannelListener = defaultChannelListener;
    }
}

