/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.server;

import com.google.inject.assistedinject.Assisted;
import io.netty.channel.socket.SocketChannel;
import java.util.Map;
import javax.inject.Inject;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.IServer;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.core.AbstractEndPointMonitor;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.core.EndPointFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEndPointMonitor
extends AbstractEndPointMonitor
implements NamedHandler {
    Logger log = LoggerFactory.getLogger(ServerEndPointMonitor.class);
    private IRouter router;
    private ITransport transport;
    private IServer server;
    @Inject
    private EndPointFactory endPointFactory;

    @Inject
    public ServerEndPointMonitor(@Assisted IServer server, @Assisted IRouter router, @Assisted ITransport transport) {
        this.router = router;
        this.transport = transport;
        this.server = server;
    }

    @Override
    public IEndPoint create(SocketChannel channel) {
        EndPoint ep = this.endPointFactory.create(channel, this.router, this.transport);
        Map<IMessageGroup, IMessageGroupProcessor> registeredGroups = this.server.getRegisteredMessageGroups();
        for (IMessageGroup key : registeredGroups.keySet()) {
            ep.registerGroupProcessor(key, registeredGroups.get(key));
        }
        Map<IMessageGroup, IPreParsingHook> registeredPreParsingHooks = this.server.getRegisteredPreParsingHooks();
        for (IMessageGroup key : registeredPreParsingHooks.keySet()) {
            ep.registerPreParsingHook(key, registeredPreParsingHooks.get(key));
        }
        return ep;
    }

    public IServer getServer() {
        return this.server;
    }

    @Override
    public String getName() {
        return "SERVER_ENDPOINT_MONITOR";
    }
}

