/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.ssl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import java.util.ArrayList;
import java.util.List;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.core.ssl.SecureHandler;
import jayeson.lib.delivery.core.ssl.SecureHandlerFactory;
import jayeson.lib.delivery.core.tcp.InitialTransport;

public class InitialSSLTransport
extends InitialTransport {
    protected SecureHandler secureHandler;

    @Inject
    public InitialSSLTransport(@Assisted Channel channel, SecureHandlerFactory shFactory) {
        this.secureHandler = shFactory.create(channel.alloc());
    }

    @Override
    public List<NamedHandler> getDefaultHandlers() {
        ArrayList<NamedHandler> returnList = new ArrayList<NamedHandler>();
        returnList.add(this.secureHandler);
        returnList.add(this.transportDetector);
        return returnList;
    }

    @Override
    public void detach(ChannelPipeline pipeline) {
        log.trace("Removing {}", (Object)this.transportDetector.getName());
        pipeline.remove(this.transportDetector.getName());
    }

    public SecureHandler getSecureHandler() {
        return this.secureHandler;
    }

    public void setSecureHandler(SecureHandler secureHandler) {
        this.secureHandler = secureHandler;
    }
}

