/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import jayeson.lib.delivery.api.SslConfig;
import jayeson.lib.delivery.core.server.DefaultServerModule;
import jayeson.lib.delivery.core.ssl.SecureHandlerFactory;
import jayeson.lib.delivery.core.ssl.SecureHandlerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureServerModule
extends DefaultServerModule {
    private static Logger log = LoggerFactory.getLogger(SecureServerModule.class);
    private SslConfig sslConfig;

    public SecureServerModule(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    @Override
    protected void configure() {
        super.configure();
        SslContext sslContext = null;
        try {
            File certificate = new File(this.sslConfig.getCertificate());
            File privateKey = new File(this.sslConfig.getPrivateKey());
            sslContext = SslContext.newServerContext((File)certificate, (File)privateKey);
        }
        catch (Exception ex) {
            try {
                log.error("Error while Setting up SSLContext.Is the ssl config set correctly?", (Throwable)ex);
                if (this.sslConfig.isEnableSelfSignedCert()) {
                    log.warn("Generating SelfSignedCertificate as SelfSignedCertificate is enabled");
                    SelfSignedCertificate ssc = new SelfSignedCertificate();
                    sslContext = SslContext.newServerContext((File)ssc.certificate(), (File)ssc.privateKey());
                }
            }
            catch (SSLException e) {
                log.error("FATAL: Error while generating SelfSignedCertificate for Server", (Throwable)e);
            }
            catch (CertificateException e) {
                log.error("FATAL: Error while generating SelfSignedCertificate for Server", (Throwable)e);
            }
        }
        if (sslContext != null) {
            this.binder().bind(SslContext.class).toInstance(sslContext);
        }
        this.bind(SecureHandlerFactory.class).to(SecureHandlerFactoryImpl.class);
    }
}

