/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import com.google.inject.Inject;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.exceptions.GroupProcessorException;
import jayeson.lib.delivery.api.exceptions.MessageCorruptedException;
import jayeson.lib.delivery.api.exceptions.MessageDecodingException;
import jayeson.lib.delivery.api.exceptions.MessageEncodingException;
import jayeson.lib.delivery.api.exceptions.PipelineException;
import jayeson.lib.delivery.api.exceptions.RequestException;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.DeliveryCoreUtility;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.core.NettyMessageWrapper;
import jayeson.lib.delivery.core.metainfo.MessageIdCode;
import jayeson.lib.delivery.core.tcp.DecodeMessageDam;
import jayeson.lib.delivery.core.tcp.DecodeStatusNotifier;
import jayeson.lib.delivery.core.tcp.EncodeMessageDam;
import jayeson.lib.delivery.core.tcp.EncodeStatusNotifier;
import jayeson.lib.delivery.tasks.RequestTimeoutTask;
import jayeson.lib.delivery.tasks.ResponseFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRouter
implements IRouter {
    private static Logger log = LoggerFactory.getLogger(AbstractRouter.class);
    protected DecodeMessageDam decodeMessageDam;
    protected EncodeMessageDam encodeMessageDam;
    protected DecodeStatusNotifier decodeStatusNotifier;
    protected EncodeStatusNotifier encodeStatusNotifier;
    private IEndPoint endPoint;
    protected Map<IMessageGroup, IMessageGroupProcessor> registeredGroupProcessors = new HashMap<IMessageGroup, IMessageGroupProcessor>();
    protected Map<IMessageGroup, IPreParsingHook> registeredPreParsingHooks = new HashMap<IMessageGroup, IPreParsingHook>();
    protected Map<Byte, IMessageGroup> byteVsMessageGroup = new HashMap<Byte, IMessageGroup>();
    protected Map<Byte, IPreParsingHook> byteVsPreParsingHook;
    protected Map<Byte, IMessageGroupProcessor> byteVsGroupProcessor = new HashMap<Byte, IMessageGroupProcessor>();
    protected Map<Byte, MetaInformationCode> metaCodes;
    private MessageIdCode metaMIDCode;
    protected Map<String, ResponseFuture> waiters;
    protected ConcurrentSkipListMap<Long, List<String>> timeOutRequestsSchedule;
    protected ScheduledFuture<Long> requestTimeoutChecker;
    private ReentrantLock requestTimeoutLock;
    private AtomicLong currentTimeout;

    @Inject
    public AbstractRouter() {
        this.byteVsPreParsingHook = new HashMap<Byte, IPreParsingHook>();
        this.waiters = new ConcurrentHashMap<String, ResponseFuture>();
        this.timeOutRequestsSchedule = new ConcurrentSkipListMap();
        this.requestTimeoutLock = new ReentrantLock();
        this.currentTimeout = new AtomicLong(0L);
    }

    @Inject
    public void setMetaCodes(Map<Byte, MetaInformationCode> metaCodes, MessageIdCode msgIdCode) {
        this.metaCodes = metaCodes;
        this.metaMIDCode = msgIdCode;
    }

    @Override
    public IRouter registerProcessor(IMessageGroup group, IMessageGroupProcessor groupProcessor) {
        if (this.byteVsGroupProcessor.containsKey(group.id())) {
            log.warn("GroupProcessor {} already exists for Group {}. Replacing with {}", new Object[]{this.byteVsGroupProcessor.get(group.id()).getClass(), group.getClass(), groupProcessor.getClass()});
        }
        this.byteVsMessageGroup.put(group.id(), group);
        this.registeredGroupProcessors.put(group, groupProcessor);
        this.byteVsGroupProcessor.put(group.id(), groupProcessor);
        return this;
    }

    public void onDecodeFinished(Object decodedMessage) throws Exception {
        NettyMessageWrapper msgWrapper = this.decodeMessageDam.signalDecodeFinished();
        msgWrapper.setMessage(decodedMessage);
        IMessageGroupProcessor groupProcessor = this.byteVsGroupProcessor.get(msgWrapper.getMessageGroup().id());
        if (decodedMessage instanceof ReferenceCounted) {
            log.warn("Referencecounted message is returned to Applicaion layer {}.Group {}.Class {}", new Object[]{decodedMessage, msgWrapper.getMessageGroup().id(), msgWrapper.getMessageClass().id()});
        }
        if (msgWrapper.hasMetaInformation(this.metaMIDCode)) {
            String messageId = msgWrapper.getMetaInformation(this.metaMIDCode);
            ResponseFuture waiter = this.clearRequest(messageId);
            if (waiter != null) {
                List<String> requestIds;
                long stopTime;
                if (!waiter.isDone()) {
                    waiter.complete(msgWrapper);
                }
                if ((stopTime = waiter.getStopTime()) > 0L && (requestIds = this.timeOutRequestsSchedule.get(stopTime)) != null) {
                    requestIds.remove(messageId);
                    if (requestIds.isEmpty()) {
                        this.timeOutRequestsSchedule.remove(stopTime);
                    }
                }
            } else {
                this.dispatchMessage(msgWrapper, groupProcessor);
            }
        } else {
            this.dispatchMessage(msgWrapper, groupProcessor);
        }
    }

    public boolean onException(PipelineException ex) {
        ex.setEndPoint(this.getEndPoint());
        NettyMessageWrapper msg = null;
        if (ex instanceof GroupProcessorException) {
            log.error("Exception in group processor while processing message", (Throwable)ex);
        } else if (ex instanceof MessageDecodingException) {
            if (ex instanceof MessageDecodingException.TransportMessageDecodingException) {
                log.error("Decoding error in Transport", (Throwable)ex);
            } else {
                msg = this.decodeMessageDam.signalDecodeFinished();
                log.error("Decoding error in Router", (Throwable)ex);
                ex.setPayLoad(msg);
            }
        } else if (ex instanceof MessageEncodingException) {
            if (ex instanceof MessageEncodingException.TransportMessageEncodingException) {
                log.error("Encoding error in Transport", (Throwable)ex);
            } else {
                msg = this.encodeMessageDam.signalEncodeFinished();
                log.error("Encoding error in Router", (Throwable)ex);
                ex.setPayLoad(msg);
            }
        } else if (ex instanceof MessageCorruptedException) {
            if (ex instanceof MessageCorruptedException) {
                log.error("Message Corrupted Exception in the pipeline", (Throwable)ex);
            }
        } else {
            log.error("Unexpected exception", (Throwable)ex);
        }
        if (ex.getPayLoad() instanceof ReferenceCounted) {
            DeliveryCoreUtility.release((ReferenceCounted)ex.getPayLoad());
        }
        if (msg != null) {
            if (msg.msg() instanceof ReferenceCounted) {
                DeliveryCoreUtility.release((ReferenceCounted)msg.msg());
            }
            if (msg.hasMetaInformation(this.metaMIDCode)) {
                List<String> requestIds;
                long stopTime;
                String requestId = msg.getMetaInformation(this.metaMIDCode);
                ResponseFuture responseFuture = this.clearRequest(requestId);
                if (responseFuture != null && !responseFuture.isDone()) {
                    responseFuture.completeExceptionally(new RequestException(ex.getCause()));
                }
                if ((stopTime = responseFuture.getStopTime()) > 0L && (requestIds = this.timeOutRequestsSchedule.get(stopTime)) != null) {
                    requestIds.remove(requestId);
                    if (requestIds.isEmpty()) {
                        this.timeOutRequestsSchedule.remove(stopTime);
                    }
                }
                return false;
            }
        }
        return this.checkIfExceptionHandlerExisits();
    }

    private boolean checkIfExceptionHandlerExisits() {
        EndPoint ep = (EndPoint)this.getEndPoint();
        return ep.isHandlerPresent("DELIVERY_EXCEPTION_HANDLER");
    }

    protected IPreParsingHook getPreParsingHook(Byte id) {
        return this.byteVsPreParsingHook.get(id);
    }

    @Override
    public EventExecutor executor() {
        EventLoop executor = ((EndPoint)this.getEndPoint()).getChannel().eventLoop();
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitRequestTimeOut() {
        long currentTime = System.currentTimeMillis();
        try {
            Map.Entry<Long, List<String>> firstEntry;
            long firstRequestTimeout;
            this.requestTimeoutLock.lock();
            if (this.requestTimeoutChecker == null) {
                if (!this.timeOutRequestsSchedule.isEmpty()) {
                    Map.Entry<Long, List<String>> firstEntry2 = this.timeOutRequestsSchedule.firstEntry();
                    long currentRequestTimeOut = firstEntry2.getKey();
                    long delay = currentRequestTimeOut - currentTime;
                    if (delay < 0L) {
                        delay = 0L;
                    }
                    EventExecutor executor = this.executor();
                    this.requestTimeoutChecker = executor.schedule((Callable)new RequestTimeoutTask(this, currentRequestTimeOut), delay, TimeUnit.MILLISECONDS);
                    log.debug("Run new task with stoptime {}", (Object)firstEntry2.getKey());
                    this.setCurrentTimeout(firstEntry2.getKey());
                }
                return;
            }
            if (!this.timeOutRequestsSchedule.isEmpty() && (firstRequestTimeout = (firstEntry = this.timeOutRequestsSchedule.firstEntry()).getKey().longValue()) < this.getCurrentTimeout()) {
                this.cancelRequestTimeout(false);
                if (this.requestTimeoutChecker == null) {
                    long delay = firstRequestTimeout - currentTime;
                    if (delay < 0L) {
                        delay = 0L;
                    }
                    EventExecutor executor = this.executor();
                    this.requestTimeoutChecker = executor.schedule((Callable)new RequestTimeoutTask(this, firstRequestTimeout), delay, TimeUnit.MILLISECONDS);
                    log.debug("re-run new task with stop time {}", (Object)firstRequestTimeout);
                    this.setCurrentTimeout(firstRequestTimeout);
                }
            }
        }
        catch (Exception e) {
            log.error("Can not fire request timeout. ", (Throwable)e);
        }
        finally {
            this.requestTimeoutLock.unlock();
        }
    }

    public void onEncodeFinished(ChannelHandlerContext ctx, Object encodedMessage) {
        NettyMessageWrapper msgWrapper = this.encodeMessageDam.signalEncodeFinished();
        msgWrapper.setMessage(encodedMessage);
        msgWrapper.setChannelHandlerContext(ctx);
        ctx.write((Object)msgWrapper, msgWrapper.getPromise());
    }

    @Override
    public IEndPoint getEndPoint() {
        return this.endPoint;
    }

    @Inject
    private void setDecodeMessageDam(DecodeMessageDam decodeMessageDam) {
        this.decodeMessageDam = decodeMessageDam;
        decodeMessageDam.setRouter(this);
        decodeMessageDam.setPreParsingHooks(this.byteVsPreParsingHook);
    }

    @Inject
    private void setEncodeMessageDam(EncodeMessageDam encodeMessageDam) {
        this.encodeMessageDam = encodeMessageDam;
    }

    @Inject
    private void setDecodeStatusNotifier(DecodeStatusNotifier decodeStatusNotifier) {
        this.decodeStatusNotifier = decodeStatusNotifier;
        decodeStatusNotifier.setRouter(this);
    }

    @Inject
    private void setEncodeStatusNotifier(EncodeStatusNotifier encodeStatusNotifier) {
        this.encodeStatusNotifier = encodeStatusNotifier;
        encodeStatusNotifier.setRouter(this);
    }

    @Override
    public void setEndPoint(IEndPoint endPoint) {
        this.endPoint = endPoint;
    }

    @Override
    public Map<IMessageGroup, IMessageGroupProcessor> getRegisteredMessageGroups() {
        HashMap<IMessageGroup, IMessageGroupProcessor> returnMap = new HashMap<IMessageGroup, IMessageGroupProcessor>();
        for (IMessageGroup key : this.registeredGroupProcessors.keySet()) {
            returnMap.put(key, this.registeredGroupProcessors.get(key));
        }
        return returnMap;
    }

    @Override
    public IRouter registerPreParsingHook(IMessageGroup group, IPreParsingHook preParsingHook) {
        if (this.byteVsPreParsingHook.containsKey(group.id())) {
            log.warn("PreParsingHook {} already exists for Group {}. Replacing with {}", new Object[]{this.byteVsPreParsingHook.get(group.id()).getClass(), group.getClass(), preParsingHook.getClass()});
        }
        this.byteVsMessageGroup.put(group.id(), group);
        this.registeredPreParsingHooks.put(group, preParsingHook);
        this.byteVsPreParsingHook.put(group.id(), preParsingHook);
        return this;
    }

    @Override
    public IRouter deregisterPreParsingHook(byte groupId) {
        IMessageGroup group = this.byteVsMessageGroup.get(groupId);
        if (group == null) {
            log.warn("Group id {} is not existed.", (Object)groupId);
            return this;
        }
        IPreParsingHook preParsingHook = this.registeredPreParsingHooks.remove(group);
        this.byteVsPreParsingHook.remove(groupId);
        preParsingHook.onDeregistered(this.endPoint);
        return this;
    }

    @Override
    public Map<IMessageGroup, IPreParsingHook> getRegisteredPreParsingHooks() {
        HashMap<IMessageGroup, IPreParsingHook> returnMap = new HashMap<IMessageGroup, IPreParsingHook>();
        for (IMessageGroup key : this.registeredPreParsingHooks.keySet()) {
            returnMap.put(key, this.registeredPreParsingHooks.get(key));
        }
        return returnMap;
    }

    public boolean parseMessage() {
        return false;
    }

    private String messageId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public ResponseFuture storeRequest(MessageWrapper message, long timeOut) {
        String messageId = this.messageId();
        message.addMetaInformation(this.metaMIDCode, messageId);
        ResponseFuture waiter = new ResponseFuture(messageId, this, timeOut);
        this.waiters.put(messageId, waiter);
        if (timeOut > 0L) {
            List<String> requestIds = this.timeOutRequestsSchedule.get(waiter.getStopTime());
            if (requestIds == null) {
                requestIds = new CopyOnWriteArrayList<String>();
                this.timeOutRequestsSchedule.put(waiter.getStopTime(), requestIds);
            }
            requestIds.add(messageId);
            this.waitRequestTimeOut();
        }
        return waiter;
    }

    private void setCurrentTimeout(long timeout) {
        if (timeout <= 0L) {
            this.currentTimeout.set(0L);
            return;
        }
        if (this.currentTimeout.get() == 0L || this.currentTimeout.get() > timeout) {
            this.currentTimeout.set(timeout);
        }
    }

    private long getCurrentTimeout() {
        return this.currentTimeout.get();
    }

    @Override
    public MessageWrapper createReply(MessageWrapper original, MessageWrapper response) {
        if (!original.hasMetaInformation(this.metaMIDCode)) {
            throw new RuntimeException("Trying to reply to a non-request message!");
        }
        response.addMetaInformation(this.metaMIDCode, original.getMetaInformation(this.metaMIDCode));
        return response;
    }

    @Override
    public ResponseFuture clearRequest(String requestId) {
        return this.waiters.remove(requestId);
    }

    public boolean hasMetaCode(Byte code) {
        return this.metaCodes.get(code) != null;
    }

    public boolean hasMetaCodes(Collection<Byte> codes) {
        for (Byte code : codes) {
            if (this.hasMetaCode(code)) continue;
            return false;
        }
        return true;
    }

    public MetaInformationCode getMetaCode(Byte code) {
        return this.metaCodes.get(code);
    }

    public void cancelRequestTimeout(boolean mayInterruptIfRunning) {
        if (this.requestTimeoutChecker != null) {
            boolean isCancelled = this.requestTimeoutChecker.cancel(mayInterruptIfRunning);
            if (isCancelled) {
                log.debug("Canceled task successfully.");
                this.requestTimeoutChecker = null;
            } else {
                log.debug("Fail to cancel task. Wait it done.");
            }
        }
    }

    @Override
    public void rejectTimeoutRequests(long stopTime, boolean runNewTask) {
        this.rejectTimeoutRequest(stopTime);
        Long currentStopTime = stopTime;
        Long currentTime = System.currentTimeMillis();
        while ((currentStopTime = this.timeOutRequestsSchedule.lowerKey(currentTime)) != null) {
            this.rejectTimeoutRequest(currentStopTime);
            currentTime = System.currentTimeMillis();
        }
        this.requestTimeoutChecker = null;
        this.setCurrentTimeout(0L);
        if (runNewTask) {
            this.waitRequestTimeOut();
        }
    }

    private void rejectTimeoutRequest(long stopTime) {
        List<String> requestIds = this.timeOutRequestsSchedule.remove(stopTime);
        if (requestIds != null) {
            for (String requestId : requestIds) {
                ResponseFuture responseFuture = this.clearRequest(requestId);
                if (responseFuture == null || responseFuture.isDone()) continue;
                responseFuture.completeExceptionally(new RequestException());
            }
            log.debug("StopTime {} has been rejected.", (Object)stopTime);
        }
    }
}

