/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import com.google.inject.Inject;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.exceptions.MessageCorruptedException;
import jayeson.lib.delivery.api.exceptions.MetaInformationException;
import jayeson.lib.delivery.api.exceptions.PipelineException;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.NettyMessageWrapper;
import jayeson.lib.delivery.core.tcp.BaseInMultiplexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMultiplexer
extends BaseInMultiplexer
implements NamedHandler {
    private static final Logger log = LoggerFactory.getLogger(InMultiplexer.class);
    private Map<Byte, MetaInformationCode> metaCodeMap;

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NettyMessageWrapper nettyMessageWrapper = null;
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (buf.readableBytes() < 3) {
                MessageCorruptedException ex = new MessageCorruptedException("Message is corrupted, received less than 3 bytes");
                ex.setPayLoad(msg);
                throw ex;
            }
            Map<Byte, String> metaInformation = this.decodeMetaInformation(buf);
            byte messageGroupValue = buf.readByte();
            IMessageGroup messageGroup = this.getGroupFromByte(messageGroupValue);
            if (messageGroup == null) {
                log.error("No MessageGroup found for {}", (Object)messageGroupValue);
                MessageCorruptedException ex = new MessageCorruptedException("Message Group value not supported.");
                ex.setPayLoad(msg);
                throw ex;
            }
            byte messageClassValue = buf.readByte();
            IMessageClass<?> messageClass = messageGroup.classById(messageClassValue);
            if (messageClass == null) {
                log.error("No MessageClass found for {} in Group {}", (Object)messageClassValue, messageGroup.getClass());
                MessageCorruptedException ex = new MessageCorruptedException("Message Class value not supported.");
                ex.setPayLoad(msg);
                throw ex;
            }
            nettyMessageWrapper = new NettyMessageWrapper(buf, messageClass);
            if (metaInformation != null) {
                for (Map.Entry<Byte, String> entry : metaInformation.entrySet()) {
                    MetaInformationCode code = this.metaCodeMap.get(entry.getKey());
                    if (code == null) {
                        log.error("No MetaInformationCode found for {} in router", (Object)code);
                        MetaInformationException ex = new MetaInformationException("Meta Information Code not supported.");
                        ex.setPayLoad(msg);
                        throw ex;
                    }
                    nettyMessageWrapper.addMetaInformation(code, entry.getValue());
                }
            }
        } else {
            log.error("Received message is {}", msg.getClass());
            PipelineException ex = new PipelineException("Received Message is not byte buf");
            throw ex;
        }
        if (nettyMessageWrapper != null) {
            ctx.fireChannelRead((Object)nettyMessageWrapper);
        }
    }

    private Map<Byte, String> decodeMetaInformation(ByteBuf rawBuf) {
        int contentLen;
        HashMap<Byte, String> metaInfo = new HashMap<Byte, String>();
        byte metaHeader = rawBuf.readByte();
        if ((metaHeader & 0x80) == 0) {
            return null;
        }
        int metaLength = (metaHeader << 8 | rawBuf.readByte()) & 0x7F;
        if (metaLength <= 0) {
            return null;
        }
        for (int i = 0; i < metaLength; i += contentLen) {
            byte firstByteInBlock = rawBuf.readByte();
            ++i;
            byte codeByte = (byte)(firstByteInBlock >> 2);
            int nBytesOfFLF = firstByteInBlock & 3;
            byte[] fieldLength = new byte[nBytesOfFLF];
            rawBuf.readBytes(fieldLength);
            i += nBytesOfFLF;
            contentLen = 0;
            for (int index = 0; index < nBytesOfFLF; ++index) {
                int leftShift = 8 * (nBytesOfFLF - 1 - index);
                contentLen |= (fieldLength[index] & 0xFF) << leftShift;
            }
            byte[] content = new byte[contentLen];
            rawBuf.readBytes(content);
            metaInfo.put(codeByte, new String(content, Charset.forName("UTF-8")));
        }
        return metaInfo;
    }

    @Override
    public String getName() {
        return "INMULTIPLEXER";
    }

    @Inject
    private void setMetaInfoCodeMap(Map<Byte, MetaInformationCode> codeMap) {
        this.metaCodeMap = codeMap;
    }
}

