/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import com.google.inject.Singleton;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCounted;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.exceptions.MessageCorruptedException;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.DeliveryCoreUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ChannelHandler.Sharable
public class OutMultiplexer
extends ChannelOutboundHandlerAdapter
implements NamedHandler {
    private static final Logger log = LoggerFactory.getLogger(OutMultiplexer.class);

    /*
     * Enabled aggressive block sorting
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof MessageWrapper)) {
            log.error("Received message is {}", msg.getClass());
            MessageCorruptedException ex = new MessageCorruptedException("Message is not MessageWrapper");
            ex.setPayLoad(msg);
            throw ex;
        }
        MessageWrapper messageWrapper = (MessageWrapper)msg;
        if (messageWrapper.msg() instanceof ByteBuf) {
            ByteBuf rawMessage = (ByteBuf)messageWrapper.msg();
            int bufLength = rawMessage.readableBytes() + 3;
            byte[] metaInformation = null;
            if (messageWrapper.hasMetaInformation()) {
                metaInformation = this.encodeMetaInfo(messageWrapper.getMetaInformation());
                if (metaInformation.length > 255) {
                    MessageCorruptedException ex = new MessageCorruptedException("Meta Informations exceed Max Meta Length.");
                    ex.setPayLoad(msg);
                    throw ex;
                }
                bufLength += metaInformation.length;
            }
            if (metaInformation != null && metaInformation.length > 255) {
                MessageCorruptedException ex = new MessageCorruptedException("Meta information cannot be greater than 255 bytes");
                ex.setPayLoad(msg);
                throw ex;
            }
            ByteBuf buf = Unpooled.buffer((int)bufLength);
            if (metaInformation == null) {
                buf.writeByte(0);
            } else {
                buf.writeBytes(metaInformation);
            }
            IMessageClass<?> messageClass = messageWrapper.getMessageClass();
            if (messageClass == null) {
                log.error("Message class is not set ");
                MessageCorruptedException ex = new MessageCorruptedException("MessageWrapper does not have class information");
                ex.setPayLoad(msg);
                throw ex;
            }
            IMessageGroup messageGroup = messageClass.group();
            if (messageGroup == null) {
                log.error("Message group is not set for class {}", msg.getClass());
                MessageCorruptedException ex = new MessageCorruptedException("MessageWrapper does not have group information");
                ex.setPayLoad(msg);
                throw ex;
            }
            buf.writeByte((int)messageGroup.id());
            buf.writeByte((int)messageClass.id());
            buf.writeBytes(rawMessage);
            ctx.write((Object)buf, promise);
            DeliveryCoreUtility.release((ReferenceCounted)rawMessage);
            return;
        }
        if (messageWrapper.msg() == null) {
            log.error("RawMessage is null");
            MessageCorruptedException ex = new MessageCorruptedException("Raw messageis not null");
            ex.setPayLoad(msg);
            throw ex;
        }
        log.error("Encoded message is {}", messageWrapper.msg().getClass());
        MessageCorruptedException ex = new MessageCorruptedException("Raw message is not byte buf");
        ex.setPayLoad(msg);
        throw ex;
    }

    @Override
    public String getName() {
        return "OUTMULTIPLEXER";
    }

    private byte[] encodeMetaInfo(Map<MetaInformationCode, String> metaHeaders) {
        if (metaHeaders.isEmpty()) {
            return new byte[]{0};
        }
        ArrayList<Byte> encodedMetaInfo = new ArrayList<Byte>();
        for (Map.Entry<MetaInformationCode, String> entry : metaHeaders.entrySet()) {
            Byte metaCode = entry.getKey().code();
            byte[] encodedFV = entry.getValue().getBytes();
            int nBytesFV = encodedFV.length;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(nBytesFV);
            byte[] convertedContentLen = buffer.array();
            ArrayList<Byte> encodedFL = new ArrayList<Byte>();
            boolean metNotZero = false;
            for (byte data : convertedContentLen) {
                if (data != 0) {
                    metNotZero = true;
                }
                if (!metNotZero) continue;
                encodedFL.add(data);
            }
            int encodedFLF = encodedFL.size();
            if (encodedFLF > 3 | encodedFLF < 0) {
                return new byte[]{0};
            }
            byte firstByte = (byte)(metaCode << 2 | (byte)(3 & encodedFLF));
            encodedMetaInfo.add(firstByte);
            encodedMetaInfo.addAll(encodedFL);
            for (int index = 0; index < encodedFV.length; ++index) {
                encodedMetaInfo.add(encodedFV[index]);
            }
        }
        int contentSize = encodedMetaInfo.size();
        short metaLength = (short)(0x8000 | contentSize);
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(metaLength);
        byte[] encodedMetaLength = buffer.array();
        byte[] result = new byte[encodedMetaLength.length + contentSize];
        result[0] = encodedMetaLength[0];
        result[1] = encodedMetaLength[1];
        for (int index = 0; index < contentSize; ++index) {
            result[2 + index] = (Byte)encodedMetaInfo.get(index);
        }
        return result;
    }
}

