/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import com.google.inject.Singleton;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.exceptions.MessageDecodingException;
import jayeson.lib.delivery.api.exceptions.MessageEncodingException;
import jayeson.lib.delivery.api.exceptions.PipelineException;

@ChannelHandler.Sharable
@Singleton
public class TransportExceptionNotifier
extends ChannelDuplexHandler
implements NamedHandler {
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (promise != null) {
            promise.removeListener((GenericFutureListener)MessageEncodingException.FIRE_ROUTER_ENCODE_EXCEPTION_ON_FAILURE);
            promise.addListener((GenericFutureListener)MessageEncodingException.FIRE_TRANSPORT_ENCODE_EXCEPTION_ON_FAILURE);
        }
        ctx.write(msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!(cause instanceof PipelineException)) {
            ctx.fireExceptionCaught((Throwable)new MessageDecodingException.TransportMessageDecodingException(cause));
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    @Override
    public String getName() {
        return "TRANSPORT_EXCEPTION_NOTIFIER";
    }
}

