/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.server.ServerEndPoint;
import jayeson.lib.delivery.module.auth.AuthContentWaiter;
import jayeson.lib.delivery.module.auth.AuthService;
import jayeson.lib.delivery.module.auth.messages.AuthGroup;
import jayeson.lib.delivery.module.auth.messages.beans.AuthContent;
import jayeson.lib.delivery.module.auth.messages.beans.TicketRenew;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthGroupProcessor
implements IMessageGroupProcessor {
    private static final Logger log = LoggerFactory.getLogger(AuthGroupProcessor.class);
    private AuthService service;
    private AuthGroup messageGroup;
    private AuthContentWaiter.F awf;
    private ScheduledExecutorService ses;
    private Map<Long, AuthContentWaiter> waiters;

    @Inject
    public AuthGroupProcessor(AuthContentWaiter.F authWaiterFactory, @Named(value="CommonSES") ScheduledExecutorService ses) {
        this.awf = authWaiterFactory;
        this.waiters = new HashMap<Long, AuthContentWaiter>();
        this.ses = ses;
    }

    @Override
    public void onRegistered(IEndPoint endpoint) {
        log.info("AuthServiceProcessor is registered to End Point {}", (Object)((ServerEndPoint)endpoint).getId());
        AuthContentWaiter waiter = this.awf.create(endpoint);
        endpoint.attachListener(this.service);
        this.waiters.put(((ServerEndPoint)endpoint).getId(), waiter);
        ((CompletableFuture)waiter.thenAcceptAsync(contentReceived -> {
            if (contentReceived.booleanValue()) {
                this.onAuthContentReceived(waiter);
            } else {
                this.onWaiterTimeout(waiter);
            }
        })).exceptionally(err -> {
            log.error("Auth error " + err.getMessage(), err);
            return null;
        });
        waiter.waitAuth();
    }

    private void onWaiterTimeout(AuthContentWaiter waiter) {
        this.removeWaiter(waiter);
        this.service.authFailed(waiter.getEndPoint());
    }

    private void removeWaiter(AuthContentWaiter waiter) {
        ServerEndPoint ep = (ServerEndPoint)waiter.getEndPoint();
        this.waiters.remove(ep.getId());
    }

    private void onAuthContentReceived(AuthContentWaiter waiter) {
        this.removeWaiter(waiter);
        try {
            this.service.authenticate(waiter.getEndPoint(), waiter.getContent());
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    @Override
    public void onDeregistered(IEndPoint endpoint) {
    }

    @Override
    public IMessageGroup messageGroup() {
        return this.messageGroup;
    }

    @Override
    public void process(MessageWrapper mw) {
        this.ses.submit(() -> {
            if (mw.getMessageClass().instanceClass() == AuthContent.class) {
                Optional<AuthContent> msg = Optional.empty();
                if (mw.msg() instanceof Optional) {
                    msg = (Optional<AuthContent>)mw.msg();
                } else if (mw.msg() instanceof AuthContent) {
                    msg = Optional.of((AuthContent)mw.msg());
                }
                if (msg.isPresent()) {
                    if (this.service.isAuthenticated(mw.getEndpoint())) {
                        return;
                    }
                    ServerEndPoint ep = (ServerEndPoint)mw.getEndpoint();
                    AuthContentWaiter waiter = this.waiters.get(ep.getId());
                    if (waiter != null) {
                        waiter.receive(msg.get());
                    }
                }
            } else if (mw.msg() instanceof TicketRenew) {
                log.debug("Received ticket renew request from {}", (Object)mw.getEndpoint().getIdentifier());
                TicketRenew msg = (TicketRenew)mw.msg();
                this.service.renewTicket((ServerEndPoint)mw.getEndpoint(), msg.getClientId(), msg.getNewTicket());
            }
        });
    }

    public void setAuthService(AuthService service) {
        this.service = service;
    }

    @Inject
    public void setMessageGroup(AuthGroup messageGroup) {
        this.messageGroup = messageGroup;
    }
}

