/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.auth;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jayeson.lib.access.AccessManager;
import jayeson.lib.access.AccessRequestBuilder;
import jayeson.lib.access.basic.SessionAccessManager;
import jayeson.lib.access.datastructure.AccessRequest;
import jayeson.lib.access.playframework.TokenAccessRequest;
import jayeson.lib.delivery.module.auth.AuthEntryConfig;
import jayeson.lib.delivery.module.auth.messages.beans.AuthContent;
import jayeson.utility.crypto.Crypto;
import jayeson.utility.crypto.HamcSHA1Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthRequestBuilder
implements AccessRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(AuthRequestBuilder.class);
    private AuthContent original;
    private AuthEntryConfig config;
    private Crypto crypto;

    public AuthRequestBuilder(Crypto crypto, AuthEntryConfig config, AuthContent content) {
        this.setOriginal(content);
        this.config = config;
        this.crypto = crypto;
    }

    public AccessRequest build(AccessManager am) {
        Set cookies = ServerCookieDecoder.LAX.decode(this.original.getSessionData());
        Cookie toDecode = null;
        for (Cookie c : cookies) {
            if (!c.name().equals(this.config.getCookieName())) continue;
            toDecode = c;
            break;
        }
        if (toDecode != null) {
            Map<String, String> cookieValues;
            Map<String, String> map = cookieValues = this.config.isSignedCookie() ? this.decode(toDecode.value()) : this.decodeFromMessage(toDecode.value());
            if (cookieValues == null) {
                return null;
            }
            TokenAccessRequest ar = new TokenAccessRequest();
            ar.setAccessToken(cookieValues.get("_at"));
            ar.setUsername(cookieValues.get("_u"));
            if (am instanceof SessionAccessManager) {
                ar.setSessionID(cookieValues.get("_sid"));
            }
            return ar;
        }
        return null;
    }

    private Map<String, String> decode(String cookieValue) {
        String[] arr = cookieValue.split("-", 2);
        if (arr.length < 2) {
            return null;
        }
        String message = "";
        for (int i = 1; i < arr.length; ++i) {
            message = message + arr[i];
        }
        String signature = arr[0];
        HamcSHA1Context ctx = new HamcSHA1Context(this.config.getCryptoSecret());
        String signed = this.crypto.sign(message, ctx);
        if (signed.equals(signature)) {
            return this.decodeFromMessage(message);
        }
        log.error("Corrupted cookie detected {} - {}", (Object)signed, (Object)signature);
        return null;
    }

    private Map<String, String> decodeFromMessage(String message) {
        List<String> arr = Arrays.asList(message.split("&"));
        Map<String, String> result = arr.stream().map(x -> x.split("=", 2)).map(p -> {
            try {
                String key = URLDecoder.decode(p[0], "utf-8");
                String value = URLDecoder.decode(p[1], "utf-8");
                return new String[]{key, value};
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(p -> p[0], p -> p[1]));
        return result;
    }

    public AuthContent getOriginal() {
        return this.original;
    }

    public void setOriginal(AuthContent original) {
        this.original = original;
    }
}

