/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.auth.messages.converter;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import jayeson.lib.delivery.core.messages.INettyHttpRequestConverter;
import jayeson.lib.delivery.module.auth.messages.beans.AuthContent;
import jayeson.lib.delivery.module.auth.messages.beans.WSAuthContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthContentHttpRequestConverter
implements INettyHttpRequestConverter<AuthContent> {
    private static final Logger log = LoggerFactory.getLogger(AuthContentHttpRequestConverter.class);
    private final String COOKIE = "Cookie";
    private final String UPGRADE = "Upgrade";
    private final String FIELDNAME_TICKET = "ticket";
    private final String FIELDNAME_CLIENT_ID = "clientId";
    private final String FIELDNAME_SCOPE = "feedScope";

    private String extractPostFieldData(HttpPostRequestDecoder decoder, String fieldName) {
        InterfaceHttpData data = decoder.getBodyHttpData(fieldName);
        if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.Attribute) {
            try {
                return ((Attribute)data).getValue();
            }
            catch (IOException e) {
                log.error("Cannot read attribute {} from request.", (Object)fieldName);
            }
        }
        return null;
    }

    @Override
    public Optional<AuthContent> convert(FullHttpRequest request) {
        HttpPostRequestDecoder decoder;
        AuthContent content = null;
        if (request.headers().get("Upgrade") != null && request.headers().get("Upgrade").equals("websocket")) {
            content = new WSAuthContent();
            this.initializeWSAuthContent(request, (WSAuthContent)content);
        } else {
            content = new AuthContent();
        }
        if (request.headers().get("Cookie") != null) {
            content.setSessionData(request.headers().get("Cookie").toString());
        }
        if (request.getMethod() == HttpMethod.GET) {
            List scope;
            QueryStringDecoder decoder2 = new QueryStringDecoder(request.getUri());
            Map parameters = decoder2.parameters();
            List param = (List)parameters.get("clientId");
            if (param != null) {
                content.setClientId((String)param.get(0));
            }
            if ((param = (List)parameters.get("ticket")) != null) {
                content.setTicket((String)param.get(0));
            }
            if ((scope = (List)parameters.get("feedScope")) != null && !scope.isEmpty()) {
                content.setFeedScope((String)scope.get(0));
            }
        } else if (request.getMethod() == HttpMethod.POST && !(decoder = new HttpPostRequestDecoder((HttpRequest)request)).isMultipart()) {
            content.setClientId(this.extractPostFieldData(decoder, "clientId"));
            content.setTicket(this.extractPostFieldData(decoder, "ticket"));
            content.setFeedScope(this.extractPostFieldData(decoder, "feedScope"));
        }
        if (content.getClientId() == null || content.getSessionData() == null || content.getTicket() == null) {
            log.trace("Cannot convert HTTP Request to AuthContent: {} - {} {} {}", new Object[]{content.getClass().getName(), content.getClientId(), content.getSessionData(), content.getTicket()});
            return Optional.empty();
        }
        return Optional.of(content);
    }

    private void initializeWSAuthContent(FullHttpRequest request, WSAuthContent content) {
        content.setWsUpgrade(true);
        String key = request.headers().get("Sec-WebSocket-Key");
        if (key == null) {
            content.setWsUpgrade(false);
            return;
        }
        String acceptSeed = key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] arr = md.digest(acceptSeed.getBytes());
            content.setWebsocketAccept(Base64.getEncoder().encodeToString(arr));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 is not supported on this platform - Outdated? Cannot support websocket then!");
        }
    }

    @Override
    public FullHttpRequest convert(AuthContent object) {
        return null;
    }
}

