/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.publisher;

import com.google.common.eventbus.Subscribe;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.events.EPConnectedEvent;
import jayeson.lib.delivery.api.events.EPDisconnectedEvent;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.module.auth.IAuthService;
import jayeson.lib.delivery.module.publisher.IEventReactor;
import jayeson.lib.delivery.module.publisher.IPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherEventReactor
implements IEventReactor {
    private static Logger log = LoggerFactory.getLogger(PublisherEventReactor.class);
    private IPublisher publisher;

    public PublisherEventReactor(IPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public IPublisher getPublisher() {
        return this.publisher;
    }

    @Subscribe
    public void eventLogic(EPEvent event) {
        IEndPoint ep = event.getEndpoint();
        if (event instanceof EPConnectedEvent) {
            log.trace("New EndPoint {} connected. Attaching AuthService", (Object)ep.getIdentifier());
            IAuthService authenticationService = this.publisher.getAuthenticationService();
            IMessageGroupProcessor gp = authenticationService.getProcessor();
            ep.registerGroupProcessor(gp.messageGroup(), gp);
        }
        if (event instanceof EPDisconnectedEvent) {
            this.publisher.dispatchEvent(event);
        }
    }
}

