/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.streamregistry;

import com.google.common.collect.HashBasedTable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.module.streamregistry.GroupStream;
import jayeson.lib.delivery.module.streamregistry.StreamState;

class EndPointState {
    final String scope;
    private String userId;
    private IEndPoint endPoint;
    private HashBasedTable<Byte, String, StreamState> streamStateTable;

    public EndPointState(String scope, String userId, IEndPoint ep) {
        this.scope = scope;
        this.userId = userId;
        this.endPoint = ep;
        this.streamStateTable = HashBasedTable.create();
    }

    public String getScope() {
        return this.scope;
    }

    public String getUserId() {
        return this.userId;
    }

    public IEndPoint getEndPoint() {
        return this.endPoint;
    }

    public boolean isRegistered(Byte messageGroup, String stream) {
        if (this.streamStateTable.isEmpty()) {
            return false;
        }
        if (!this.streamStateTable.containsRow((Object)messageGroup)) {
            return false;
        }
        Map streamMap = this.streamStateTable.row((Object)messageGroup);
        return streamMap.get(stream) == StreamState.REGISTERED || streamMap.get(stream) == StreamState.CONSUMED;
    }

    public boolean isConsumed(Byte messageGroup, String stream) {
        if (this.streamStateTable.isEmpty()) {
            return false;
        }
        if (!this.streamStateTable.containsRow((Object)messageGroup)) {
            return false;
        }
        Map streamMap = this.streamStateTable.row((Object)messageGroup);
        return streamMap.get(stream) == StreamState.CONSUMED;
    }

    public void annotateStreamAsConsumed(Byte messageGroup, String stream) {
        this.streamStateTable.put((Object)messageGroup, (Object)stream, (Object)StreamState.CONSUMED);
    }

    public void annotateStreamAsRegistered(Byte messageGroup, String stream) {
        this.streamStateTable.put((Object)messageGroup, (Object)stream, (Object)StreamState.REGISTERED);
    }

    public void annotateStreamAsDeRegistered(Byte messageGroup, String stream) {
        this.streamStateTable.put((Object)messageGroup, (Object)stream, (Object)StreamState.DEREGISTERED);
    }

    public List<GroupStream> getConsumingStreams() {
        return this.streamStateTable.cellSet().stream().filter(cell -> cell.getValue() == StreamState.CONSUMED).map(cell -> new GroupStream((Byte)cell.getRowKey(), (String)cell.getColumnKey())).collect(Collectors.toList());
    }

    public Set<String> getConsumingStreams(Byte messageGroup) {
        HashSet<String> returnSet = new HashSet<String>();
        if (this.streamStateTable.isEmpty()) {
            return returnSet;
        }
        if (!this.streamStateTable.containsRow((Object)messageGroup)) {
            return returnSet;
        }
        Map streamMap = this.streamStateTable.row((Object)messageGroup);
        for (String stream : streamMap.keySet()) {
            if (streamMap.get(stream) != StreamState.CONSUMED) continue;
            returnSet.add(stream);
        }
        return returnSet;
    }

    public Set<String> getRegisteredStreams(Byte messageGroup) {
        HashSet<String> returnSet = new HashSet<String>();
        if (this.streamStateTable.isEmpty()) {
            return returnSet;
        }
        if (!this.streamStateTable.containsRow((Object)messageGroup)) {
            return returnSet;
        }
        Map streamMap = this.streamStateTable.row((Object)messageGroup);
        for (String stream : streamMap.keySet()) {
            if (streamMap.get(stream) != StreamState.REGISTERED && streamMap.get(stream) != StreamState.CONSUMED) continue;
            returnSet.add(stream);
        }
        return returnSet;
    }
}

