/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.streamregistry;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.module.ModuleUtility;
import jayeson.lib.delivery.module.streamregistry.GroupStream;
import jayeson.lib.delivery.module.streamregistry.ProfileCache;
import jayeson.lib.delivery.module.streamregistry.StreamRegistryConfig;
import jayeson.lib.delivery.module.streamregistry.event.StartStreamPublishingEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamDeRegistrationEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistrationEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistryEvent;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryMessageGroup;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryRequest;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryResponse;
import jayeson.lib.streamfinder.User;
import jayeson.service.delivery.ScopePersist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRegistryGroupProcessor
implements IMessageGroupProcessor {
    private static Logger log = LoggerFactory.getLogger(StreamRegistryGroupProcessor.class);
    @Inject
    private StreamRegistryMessageGroup streamRegistryMessageGroup;
    @Inject
    private ProfileCache profileCache;
    @Inject
    private IEPEventDispatcher eventDispatcher;
    ScopePersist scopeToPersist;
    StreamRegistryConfig config;
    static final ScheduledExecutorService streamRegistryExctor = Executors.newSingleThreadScheduledExecutor(ModuleUtility.getNamedThreadFactory("delivery-streamregistry-executor-%d"));
    Future<?> lastRunTask;

    @Override
    public void onRegistered(IEndPoint endpoint) {
        log.trace("StreaRegistryGroupProcessor is registered to endpoint {}", (Object)endpoint.getIdentifier());
    }

    @Override
    public void onDeregistered(IEndPoint endpoint) {
        log.trace("StreaRegistryGroupProcessor is deregistered to endpoint {}", (Object)endpoint.getIdentifier());
    }

    @Override
    public IMessageGroup messageGroup() {
        return this.streamRegistryMessageGroup;
    }

    @Override
    public void process(final MessageWrapper mw) {
        this.lastRunTask = streamRegistryExctor.submit(new Runnable(){

            @Override
            public void run() {
                StreamRegistryGroupProcessor.this.processMessage(mw);
            }
        });
    }

    public void processMessage(MessageWrapper mw) {
        if (mw == null) {
            log.error("Received null MessageWrapper.");
            return;
        }
        if (mw.msg() == null) {
            log.error("Received null Raw Message.");
            return;
        }
        if (mw.msg() instanceof StreamRegistryRequest) {
            StreamRegistryRequest request = (StreamRegistryRequest)mw.msg();
            if (request.getRequestType() == 0) {
                this._processStreamRegistrationRequestMessage(mw.getEndpoint(), request);
            } else if (request.getRequestType() == 1) {
                this._processStreamConsumptionRequestMessage(mw.getEndpoint(), request);
            } else if (request.getRequestType() == 2) {
                this._processStreamDeRegistrationRequestMessage(mw.getEndpoint(), request);
            } else {
                log.error("Received non compliant Request message format for user {} from EndPoint {} ", (Object)this.profileCache.getUserid(mw.getEndpoint()), (Object)mw.getEndpoint().getIdentifier());
                this._sendRespone(3, mw.getEndpoint(), null, null, "Non compliant RegistryRequest");
            }
        } else {
            log.error("Received non compliant message format for user {} from EndPoint {} ", (Object)this.profileCache.getUserid(mw.getEndpoint()), (Object)mw.getEndpoint().getIdentifier());
            this._sendRespone(3, mw.getEndpoint(), null, null, "Non compliant message object");
        }
    }

    @Inject
    public void setScopePersist(ScopePersist scopeToPersist) {
        this.scopeToPersist = scopeToPersist;
    }

    private void _processStreamRegistrationRequestMessage(IEndPoint ep, StreamRegistryRequest request) {
        if (request.getMessageGroup() == null || "".equals(request.getMessageGroup())) {
            this._sendRespone(0, ep, request.getMessageGroup(), request.getStreams(), 5, "Requested MessageGroup is not valid");
            return;
        }
        if (request.getStreams() == null || request.getStreams().isEmpty()) {
            this._sendRespone(0, ep, request.getMessageGroup(), request.getStreams(), 5, "Requested Streams are not valid");
            return;
        }
        String userId = this.profileCache.getUserid(ep);
        if (userId == null) {
            log.error("FATAL error. EndPoint is not present in profile cache.");
            this._sendRespone(0, ep, request.getMessageGroup(), request.getStreams(), 5, "InternalError");
            return;
        }
        String scope = this.profileCache.getScopeOf(ep);
        if (scope == null) {
            log.error("FATAL error. EndPoint is not present in profile cache.");
            this._sendRespone(0, ep, request.getMessageGroup(), request.getStreams(), 5, "InternalError");
            return;
        }
        String puName = this.scopeToPersist.get(scope);
        User user = this.profileCache.findFeedUserByName(puName, userId);
        if (user == null) {
            log.error("FATAL error. No User in UserRepository  for userId {} ", (Object)userId);
            this._sendRespone(0, ep, request.getMessageGroup(), request.getStreams(), 5, "InternalError identifying your profile.");
            return;
        }
        Byte group = request.getMessageGroup();
        HashSet<String> registeredStreams = new HashSet<String>();
        HashMap<String, StreamRegistryEvent.StreamNegotiationStatus> streamMap = new HashMap<String, StreamRegistryEvent.StreamNegotiationStatus>();
        for (String stream : request.getStreams()) {
            if (user.canAccess(group.byteValue(), stream) && !this.profileCache.isStreamBlocked(new GroupStream(group, stream))) {
                log.info("UserRepo indicated that user {} can access Group {} , Stream {} ", new Object[]{userId, group, stream});
                registeredStreams.add(stream);
                streamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.PENDING);
                continue;
            }
            streamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.FAIL);
        }
        if (registeredStreams.isEmpty()) {
            this._sendRespone(0, ep, group, request.getStreams(), 5, "None of the requested streams can be successfully registered. Please check your Stream permissions");
            return;
        }
        StreamRegistrationEvent streamRegistrationEvent = new StreamRegistrationEvent(ep, group, scope);
        streamRegistrationEvent.setStreams(streamMap);
        streamRegistrationEvent.setUser(user);
        this.eventDispatcher.dispatchEvent(streamRegistrationEvent);
    }

    private void _processStreamConsumptionRequestMessage(IEndPoint ep, StreamRegistryRequest request) {
        if (request.getMessageGroup() == null || "".equals(request.getMessageGroup())) {
            this._sendRespone(1, ep, request.getMessageGroup(), request.getStreams(), 5, "Requested Consumption MessageGroup is not valid");
            return;
        }
        if (request.getStreams() == null || request.getStreams().isEmpty()) {
            this._sendRespone(1, ep, request.getMessageGroup(), request.getStreams(), 5, "Requested Consumption Streams are not valid");
            return;
        }
        Byte group = request.getMessageGroup();
        HashSet<String> consumptionAllowedStreams = new HashSet<String>();
        HashMap<String, StreamRegistryEvent.StreamNegotiationStatus> eventStreamMap = new HashMap<String, StreamRegistryEvent.StreamNegotiationStatus>();
        HashMap<String, Integer> responseStreamMap = new HashMap<String, Integer>();
        for (String stream : request.getStreams()) {
            if (this.profileCache.isRegistered(ep, group, stream)) {
                consumptionAllowedStreams.add(stream);
                eventStreamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.SUCCESS);
                responseStreamMap.put(stream, 4);
                continue;
            }
            eventStreamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.FAIL);
            responseStreamMap.put(stream, 5);
        }
        if (consumptionAllowedStreams.isEmpty()) {
            this._sendRespone(1, ep, group, request.getStreams(), 5, "None of the Streams requested for consumption are registered. Please send registration message");
        } else {
            this._sendRespone(1, ep, group, responseStreamMap, null);
        }
        if (!consumptionAllowedStreams.isEmpty()) {
            StartStreamPublishingEvent streamPublishingEvent = new StartStreamPublishingEvent(ep, group);
            streamPublishingEvent.setStreams(eventStreamMap);
            this.eventDispatcher.dispatchEvent(streamPublishingEvent);
            this.profileCache.annotateStreamAsConsumed(ep, group, consumptionAllowedStreams);
        }
    }

    private void _processStreamDeRegistrationRequestMessage(IEndPoint endpoint, StreamRegistryRequest request) {
        if (request.getMessageGroup() == null || "".equals(request.getMessageGroup())) {
            this._sendRespone(2, endpoint, request.getMessageGroup(), request.getStreams(), 5, "Requested MessageGroup is not valid");
            return;
        }
        if (request.getStreams() == null || request.getStreams().isEmpty()) {
            this._sendRespone(2, endpoint, request.getMessageGroup(), request.getStreams(), 5, "Requested Streams are not valid");
            return;
        }
        HashSet<String> registeredStreams = new HashSet<String>();
        HashMap<String, StreamRegistryEvent.StreamNegotiationStatus> streamMap = new HashMap<String, StreamRegistryEvent.StreamNegotiationStatus>();
        for (String stream : request.getStreams()) {
            if (this.profileCache.isRegistered(endpoint, request.getMessageGroup(), stream)) {
                registeredStreams.add(stream);
                streamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.PENDING);
                continue;
            }
            streamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.SUCCESS);
        }
        if (registeredStreams.isEmpty()) {
            this._sendRespone(2, endpoint, request.getMessageGroup(), request.getStreams(), 4, "Requested Streams are not registered previously");
            return;
        }
        StreamDeRegistrationEvent streamDeRegistrationEvent = new StreamDeRegistrationEvent(endpoint, request.getMessageGroup());
        streamDeRegistrationEvent.setStreams(streamMap);
        this.eventDispatcher.dispatchEvent(streamDeRegistrationEvent);
    }

    private void _sendRespone(int responseType, IEndPoint ep, Byte messageGroup, Set<String> streamSet, int successCode, String comment) {
        StreamRegistryResponse response = new StreamRegistryResponse(messageGroup, null, responseType);
        response.setStreams(streamSet, successCode);
        response.setComment(comment);
        MessageWrapper returnObj = new MessageWrapper(response, this.streamRegistryMessageGroup.classById((byte)1));
        try {
            ep.send(returnObj);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void _sendRespone(int responseType, IEndPoint ep, Byte messageGroup, Map<String, Integer> streamMap, String comment) {
        StreamRegistryResponse response = new StreamRegistryResponse(messageGroup, streamMap, responseType);
        response.setComment(comment);
        MessageWrapper returnObj = new MessageWrapper(response, this.streamRegistryMessageGroup.classById((byte)1));
        try {
            ep.send(returnObj);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public IEPEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void setEventDispatcher(IEPEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public ProfileCache getProfileCache() {
        return this.profileCache;
    }

    public void setProfileCache(ProfileCache profileCache) {
        this.profileCache = profileCache;
    }

    public StreamRegistryMessageGroup getStreamRegistryMessageGroup() {
        return this.streamRegistryMessageGroup;
    }

    public void setStreamRegistryMessageGroup(StreamRegistryMessageGroup streamRegistryMessageGroup) {
        this.streamRegistryMessageGroup = streamRegistryMessageGroup;
    }

    @Inject
    public void setConfig(StreamRegistryConfig config) {
        this.config = config;
    }
}

