/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.streamregistry.event;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.events.EPEvent;

public abstract class StreamRegistryEvent
extends EPEvent {
    private Map<String, StreamNegotiationStatus> streams;
    private byte messageGroup;

    public StreamRegistryEvent(IEndPoint ep, byte messageGroup) {
        super(ep);
        this.messageGroup = messageGroup;
    }

    public byte getMessageGroup() {
        return this.messageGroup;
    }

    public void setMessageGroup(byte messageGroup) {
        this.messageGroup = messageGroup;
    }

    public Map<String, StreamNegotiationStatus> getStreams() {
        return this.streams;
    }

    public void setStreams(Map<String, StreamNegotiationStatus> streams) {
        this.streams = streams;
    }

    public Set<String> getStreamsWithStatus(StreamNegotiationStatus streamStatus) {
        HashSet<String> returnSet = new HashSet<String>();
        if (this.streams == null) {
            return returnSet;
        }
        for (String stream : this.streams.keySet()) {
            if (this.streams.get(stream) != streamStatus) continue;
            returnSet.add(stream);
        }
        return returnSet;
    }

    public static enum StreamNegotiationStatus {
        PENDING,
        SUCCESS,
        FAIL;

    }
}

