/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriber;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriberConfig;
import jayeson.lib.delivery.module.subscriber.SessionTicketRenewalTask;
import jayeson.lib.delivery.module.subscriber.SubscriberConstants;
import jayeson.lib.streamfinder.SessionTicket;
import jayeson.lib.streamfinder.SessionToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationSupervisor {
    private static Logger log = LoggerFactory.getLogger(AuthenticationSupervisor.class);
    private ScheduledExecutorService scheduledExecService;
    private SessionTicket sessionTicket;
    private final String clientId = SubscriberConstants.getUniqueClientId();
    private ScopedSubscriber subscriber;
    private Provider<SessionTicketRenewalTask> ticketRenewalTaskProvider;
    private ScheduledFuture<?> ticketRenewalFuture;
    private ScopedSubscriberConfig scopeConfig;

    @AssistedInject
    public AuthenticationSupervisor(Provider<SessionTicketRenewalTask> ticketRenewalTaskProvider, @Assisted(value="scopeConfig") ScopedSubscriberConfig scopeConfig, @Named(value="SUBSCRIBER_EXECUTOR") ScheduledExecutorService executorService) {
        this.ticketRenewalTaskProvider = ticketRenewalTaskProvider;
        this.scopeConfig = scopeConfig;
        this.scheduledExecService = executorService;
    }

    public void start() {
        this.stop();
        this.ticketRenewalFuture = this.scheduledExecService.scheduleWithFixedDelay(this.createSessionTicketRenewalTask(), 0L, this.subscriber.getSubscriberConfig().getAuthDataRenewIntervalMs(), TimeUnit.MILLISECONDS);
    }

    private SessionTicketRenewalTask createSessionTicketRenewalTask() {
        SessionTicketRenewalTask task = (SessionTicketRenewalTask)this.ticketRenewalTaskProvider.get();
        task.setAuthSupervisor(this);
        task.setClientId(this.clientId);
        task.setUsername(this.scopeConfig.getSfConfig().getUsername());
        task.setPassword(this.scopeConfig.getSfConfig().getPassword());
        task.setUrl(this.scopeConfig.getSfConfig().getDiscoveryUri());
        return task;
    }

    void stop() {
        this.stopSessionTicketRenewalFuture();
    }

    private void stopSessionTicketRenewalFuture() {
        if (this.ticketRenewalFuture != null) {
            this.ticketRenewalFuture.cancel(true);
        }
    }

    public SessionToken getSessionToken() {
        if (this.sessionTicket != null) {
            SessionToken token = new SessionToken(this.sessionTicket.getSessionId(), this.sessionTicket.getAccessToken(), this.sessionTicket.getCookie(), this.sessionTicket.getError());
            return token;
        }
        return null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getTicket() {
        if (this.sessionTicket != null) {
            return this.sessionTicket.getTicket();
        }
        return null;
    }

    public ScopedSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(ScopedSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void actOnSessionTicket(SessionTicket sessionTicket) {
        this.sessionTicket = sessionTicket;
        SessionToken token = new SessionToken(sessionTicket.getSessionId(), sessionTicket.getAccessToken(), sessionTicket.getCookie(), sessionTicket.getError());
        this.subscriber.actOnSessionToken(token);
        String ticket = sessionTicket.getTicket();
        this.subscriber.actOnTicket(ticket);
    }

    public ScheduledExecutorService getScheduledExecService() {
        return this.scheduledExecService;
    }

    public void setScheduledExecService(ScheduledExecutorService scheduledExecService) {
        this.scheduledExecService = scheduledExecService;
    }
}

