/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import jayeson.lib.delivery.api.IClient;
import jayeson.lib.delivery.module.subscriber.ConnectionState;

public class ConnectionInfo {
    private IClient client;
    private String serviceId;
    private ConnectionState state;
    private long lastConnectionTimeMs;
    private int retryCount = 0;
    private boolean lifeCycleComplete = false;

    public ConnectionInfo(String serviceId, IClient client) {
        this.serviceId = serviceId;
        this.client = client;
    }

    public void changeState(ConnectionState newState) {
        if (newState == ConnectionState.CONNECTING) {
            ++this.retryCount;
        }
        if (newState == ConnectionState.DISCONNECTED) {
            this.lastConnectionTimeMs = System.currentTimeMillis();
        }
        if (newState == ConnectionState.CONNECTED) {
            this.lastConnectionTimeMs = System.currentTimeMillis();
            this.retryCount = 0;
        }
        this.state = newState;
    }

    public void setLifeCycleComplete(boolean lifeCycleComplete) {
        this.lifeCycleComplete = lifeCycleComplete;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public ConnectionState getState() {
        return this.state;
    }

    public long getLastConnectionTimeMs() {
        return this.lastConnectionTimeMs;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean isLifeCycleComplete() {
        return this.lifeCycleComplete;
    }

    public IClient getClient() {
        return this.client;
    }
}

