/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Inject;
import java.util.concurrent.CompletionStage;
import jayeson.lib.delivery.module.subscriber.AuthenticationSupervisor;
import jayeson.lib.streamfinder.SessionFactory;
import jayeson.lib.streamfinder.SessionTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTicketRenewalTask
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(SessionTicketRenewalTask.class);
    private String clientId;
    private AuthenticationSupervisor authSupervisor;
    @Inject
    private SessionFactory sessionFactory;
    private String username;
    private String password;
    private String url;
    private long ticketTryInterval = 1000L;

    @Override
    public void run() {
        SessionTicket sessionTicket = null;
        while (sessionTicket == null) {
            try {
                CompletionStage ticketFuture = this.sessionFactory.makeAuthContent(this.username, this.password, this.url, this.clientId);
                sessionTicket = (SessionTicket)ticketFuture.toCompletableFuture().get();
            }
            catch (Exception ex) {
                log.error("Error while generating new ticket", (Throwable)ex);
                try {
                    Thread.sleep(this.ticketTryInterval);
                }
                catch (InterruptedException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        this.authSupervisor.actOnSessionTicket(sessionTicket);
    }

    public void setUsername(String userName) {
        this.username = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AuthenticationSupervisor getAuthSupervisor() {
        return this.authSupervisor;
    }

    public void setAuthSupervisor(AuthenticationSupervisor authSupervisor) {
        this.authSupervisor = authSupervisor;
    }

    public long getTicketTryInterval() {
        return this.ticketTryInterval;
    }

    public void setTicketTryInterval(long ticketTryInterval) {
        this.ticketTryInterval = ticketTryInterval;
    }
}

