/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Inject;
import java.util.HashSet;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryMessageGroup;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryRequest;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryResponse;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriber;
import jayeson.lib.delivery.module.subscriber.StreamId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberStreamRegistryGroupProcessor
implements IMessageGroupProcessor {
    private static Logger log = LoggerFactory.getLogger(SubscriberStreamRegistryGroupProcessor.class);
    private ScopedSubscriber subscriber;
    @Inject
    StreamRegistryMessageGroup streamGroup;
    public static final long DELAY_BETWEEN_STREAM_REGISTRATION_MS = 1000L;
    public static final long DEREGISTRATION_TIMEOUT_MS = 7000L;

    @Inject
    public SubscriberStreamRegistryGroupProcessor() {
    }

    @Override
    public void process(MessageWrapper mw) {
        if (mw == null) {
            log.error("Fatal. Received Empty Message in wrapper");
            return;
        }
        if (mw.msg() == null) {
            log.error("Received Empty Ramw message for {} from {}", mw.getMessageClass(), (Object)mw.getEndpoint().getIdentifier());
            return;
        }
        if (mw.msg() instanceof StreamRegistryRequest) {
            log.error("Received Non compliant message {} from {} .Expecting only response", (Object)mw.msg().toString(), (Object)mw.getEndpoint().getIdentifier());
            return;
        }
        this.subscriber.actOnStreamRegistryResponse(mw.getEndpoint(), (StreamRegistryResponse)mw.msg());
    }

    protected void registerStream(IEndPoint ep, StreamId streamId) {
        StreamRegistryRequest request = new StreamRegistryRequest();
        request.setMessageGroup(streamId.group);
        HashSet<String> streams = new HashSet<String>();
        streams.add(streamId.stream);
        request.setStreams(streams);
        request.setRequestType(0);
        this._sendMessage(request, ep);
    }

    protected void deRegisterStream(IEndPoint ep, StreamId streamId) {
        StreamRegistryRequest request = new StreamRegistryRequest();
        request.setMessageGroup(streamId.group);
        HashSet<String> streams = new HashSet<String>();
        streams.add(streamId.stream);
        request.setStreams(streams);
        request.setRequestType(2);
        log.info("Sending deregistration request: {}", (Object)ep.getIdentifier());
        this._sendMessage(request, ep);
    }

    private void _sendMessage(StreamRegistryRequest request, IEndPoint ep) {
        MessageWrapper mw = new MessageWrapper(request, this.streamGroup.classById((byte)0));
        try {
            ep.send(mw);
        }
        catch (Exception e) {
            log.error("Error sending StreamRegistrationRequest for  {} {} to endpoint {}", new Object[]{request.getMessageGroup(), request.getStreams().toString(), ep.getIdentifier(), e});
        }
    }

    protected void consumeStream(IEndPoint ep, StreamId streamId) {
        StreamRegistryRequest request = new StreamRegistryRequest();
        request.setMessageGroup(streamId.group);
        HashSet<String> streams = new HashSet<String>();
        streams.add(streamId.stream);
        request.setStreams(streams);
        request.setRequestType(1);
        MessageWrapper mw = new MessageWrapper(request, this.streamGroup.classById((byte)0));
        try {
            ep.send(mw);
        }
        catch (Exception e) {
            log.error("Error sending StreamConsumption for  {} {} to endpoint {}", new Object[]{streamId.group, streamId.stream, ep.getIdentifier(), e});
        }
    }

    @Override
    public void onRegistered(IEndPoint endpoint) {
        log.info("SubscriberStreamRegistryGroupProcessor registered to endpoint {}", (Object)endpoint.getIdentifier());
    }

    @Override
    public IMessageGroup messageGroup() {
        return this.streamGroup;
    }

    @Override
    public void onDeregistered(IEndPoint endpoint) {
    }

    public void dropState(IEndPoint endpoint) {
    }

    public ScopedSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(ScopedSubscriber subscriber) {
        this.subscriber = subscriber;
    }
}

