/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.persistence.EntityManager;
import jayeson.database.DatabaseManager;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPDisconnectedEvent;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.module.auth.event.AuthEvent;
import jayeson.lib.delivery.module.streamregistry.IStreamRegistry;
import jayeson.lib.delivery.module.streamregistry.event.StartStreamPublishingEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamDeRegistrationCompleteEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamDeRegistrationEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistrationCompleteEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistrationEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistryEvent;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.service.delivery.AdvertMultiplexer;
import jayeson.service.delivery.IProcessingEngine;
import jayeson.service.delivery.ScopePersist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessingEngine
implements IProcessingEngine {
    ScopePersist scopePersist;
    private DatabaseManager manager;
    private AdvertMultiplexer advertiser;
    private ISubscriber subscriber;
    private IStreamRegistry streamRegistry;
    private IEPEventDispatcher eventDispatcher;
    private ScheduledExecutorService ses;
    final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public AbstractProcessingEngine() {
    }

    @Override
    public void onEvent(EPEvent event) {
        if (event instanceof StreamRegistryEvent) {
            StreamRegistryEvent sre = (StreamRegistryEvent)event;
            if (this.getMessageGroup().id() == sre.getMessageGroup()) {
                if (event instanceof StreamRegistrationEvent) {
                    StreamRegistrationCompleteEvent completeEvent = this.processStreamRegistrationEvent((StreamRegistrationEvent)sre);
                    this.eventDispatcher.dispatchEvent(completeEvent);
                } else if (event instanceof StreamDeRegistrationEvent) {
                    StreamDeRegistrationCompleteEvent completeEvent = this.processStreamDeRegistrationEvent((StreamDeRegistrationEvent)sre);
                    this.eventDispatcher.dispatchEvent(completeEvent);
                } else if (event instanceof StartStreamPublishingEvent) {
                    this.processStartStreamPublishingEvent((StartStreamPublishingEvent)sre);
                }
            }
        } else if (event instanceof EPDisconnectedEvent) {
            this.actOnEndPointDiscontinued(event.getEndpoint());
        } else if (event instanceof AuthEvent) {
            this.actOnEndPointAuthenticated(event.getEndpoint());
        }
    }

    private StreamRegistrationCompleteEvent processStreamRegistrationEvent(StreamRegistrationEvent event) {
        StreamRegistrationCompleteEvent eve = new StreamRegistrationCompleteEvent(event.getEndpoint(), event.getMessageGroup());
        Map<String, StreamRegistryEvent.StreamNegotiationStatus> streamMap = event.getStreams();
        for (String stream : streamMap.keySet()) {
            if (streamMap.get(stream) != StreamRegistryEvent.StreamNegotiationStatus.PENDING) continue;
            boolean isSuccess = this.actOnStreamRegistrationRequest(event.getEndpoint(), stream);
            if (isSuccess) {
                streamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.SUCCESS);
                continue;
            }
            streamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.FAIL);
        }
        eve.setStreams(streamMap);
        return eve;
    }

    private StreamDeRegistrationCompleteEvent processStreamDeRegistrationEvent(StreamDeRegistrationEvent event) {
        StreamDeRegistrationCompleteEvent eve = new StreamDeRegistrationCompleteEvent(event.getEndpoint(), event.getMessageGroup());
        Map<String, StreamRegistryEvent.StreamNegotiationStatus> streamMap = event.getStreams();
        for (String stream : streamMap.keySet()) {
            if (streamMap.get(stream) != StreamRegistryEvent.StreamNegotiationStatus.PENDING) continue;
            boolean isSuccess = this.actOnStreamDeRegistrationRequest(event.getEndpoint(), stream);
            if (isSuccess) {
                streamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.SUCCESS);
                continue;
            }
            streamMap.put(stream, StreamRegistryEvent.StreamNegotiationStatus.FAIL);
        }
        eve.setStreams(streamMap);
        return eve;
    }

    private void processStartStreamPublishingEvent(StartStreamPublishingEvent event) {
        Map<String, StreamRegistryEvent.StreamNegotiationStatus> streamMap = event.getStreams();
        for (String stream : streamMap.keySet()) {
            this.startPublishing(event.getEndpoint(), stream);
        }
    }

    protected abstract boolean actOnStreamRegistrationRequest(IEndPoint var1, String var2);

    protected abstract boolean actOnStreamDeRegistrationRequest(IEndPoint var1, String var2);

    protected abstract void startPublishing(IEndPoint var1, String var2);

    protected abstract void actOnEndPointDiscontinued(IEndPoint var1);

    protected void actOnEndPointAuthenticated(IEndPoint ep) {
    }

    @Override
    public void attachListener(IEndPointListener listener) {
        this.eventDispatcher.registerListener(listener);
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this.eventDispatcher.deregisterListener(listener);
    }

    @Inject
    public void setEventDispatcher(IEPEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public IStreamRegistry getStreamRegistry() {
        return this.streamRegistry;
    }

    @Override
    @Inject
    public void setStreamRegistry(IStreamRegistry streamRegistry) {
        this.streamRegistry = streamRegistry;
    }

    @Override
    public ISubscriber getSubscriber() {
        return this.subscriber;
    }

    @Override
    @Inject
    public void setSubscriber(ISubscriber subscriber) {
        this.subscriber = subscriber;
    }

    @Inject
    public void setAdvertiser(AdvertMultiplexer advertiser) {
        this.advertiser = advertiser;
    }

    @Inject
    public void setScopePersist(ScopePersist config) {
        this.scopePersist = config;
    }

    @Inject
    public void setDbManager(DatabaseManager manager) {
        this.manager = manager;
    }

    @Inject
    public void setSes(@Named(value="CommonSES") ScheduledExecutorService ses) {
        this.ses = ses;
    }

    public EntityManager getDbFor(String scope) {
        String puName = this.scopePersist.get(scope);
        if (puName == null) {
            return null;
        }
        return this.manager.getEM(puName);
    }

    @Override
    public void startStream(String streamName, int level) {
        this.advertiser.advertise(this.getMessageGroup().id(), streamName, level);
    }

    @Override
    public void setConnected(boolean value) {
        this.advertiser.setConnected(value);
    }

    @Override
    public CompletableFuture<Void> stopStream(String streamName, int level, long timeout) {
        CompletableFuture<Void> stopMessageSent = this.getStreamRegistry().blockStream(timeout, this.getMessageGroup().id(), streamName);
        CompletionStage removeAdv = stopMessageSent.thenAccept(x -> this.advertiser.remove(this.getMessageGroup().id(), streamName));
        if (timeout != -1L) {
            removeAdv = ((CompletableFuture)removeAdv).thenAccept(x -> this.ses.schedule(() -> this.startStream(streamName, level), timeout, TimeUnit.MILLISECONDS));
        }
        return removeAdv;
    }

    protected AdvertMultiplexer getAdvertiser() {
        return this.advertiser;
    }
}

