/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import jayeson.lib.delivery.module.publisher.IPublisher;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.service.delivery.AbstractProcessingEngine;
import jayeson.service.delivery.IProcessingEngine;

@Singleton
public class Amalgamate
implements Runnable {
    IPublisher publisher;
    ISubscriber subscriber;
    Set<AbstractProcessingEngine> processors;

    @Inject
    public Amalgamate(Set<AbstractProcessingEngine> processors, IPublisher publisher, ISubscriber subscriber) throws InstantiationException {
        this.processors = processors;
        this.publisher = publisher;
        this.subscriber = subscriber;
        this.run();
    }

    @Override
    public void run() {
        HashSet<IProcessingEngine> pe = new HashSet<IProcessingEngine>(this.processors);
        this.publisher.setProcessingEngines(pe);
        this.publisher.startPublishing();
        this.subscriber.startConsuming();
        this.processors.stream().forEach(IProcessingEngine::onStartUp);
    }

    public Set<AbstractProcessingEngine> getProcessors() {
        return this.processors;
    }
}

